/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.exceptions.CorruptedWorldException;
import com.infernalsuite.asp.api.exceptions.NewerFormatException;
import com.infernalsuite.asp.api.exceptions.SlimeException;
import com.infernalsuite.asp.api.exceptions.UnknownWorldException;
import com.infernalsuite.asp.api.exceptions.WorldAlreadyExistsException;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import com.infernalsuite.asp.api.world.SlimeWorld;
import dev.danielmillar.slimelink.SlimeLink;
import dev.danielmillar.slimelink.config.ConfigManager;
import dev.danielmillar.slimelink.config.WorldData;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Clone Slime World")
@Description(value={"This effect allows you to clone an existing SlimeWorld into another.", "You may also specify a data source if you're cloning to a different one from the original world."})
@Examples(value={"clone slimeworld from \"Test\" to \"TestCopy\"", "clone slime world from \"MyWorld\" to \"MyWorldBackup\" as ReadOnly with datasource mysql"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J?\u0010\u0012\u001a\u00020\t2\u0014\u0010\u0013\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001f"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffCloneWorld;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "sourceWorldName", "Lch/njol/skript/lang/Expression;", "", "targetWorldName", "isNewSource", "", "loaderType", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "isReadOnly", "Ljava/lang/Boolean;", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "execute", "", "Companion", "SlimeLink"})
@SourceDebugExtension(value={"SMAP\nEffCloneWorld.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffCloneWorld.kt\ndev/danielmillar/slimelink/skript/effects/EffCloneWorld\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,162:1\n29#2,3:163\n*S KotlinDebug\n*F\n+ 1 EffCloneWorld.kt\ndev/danielmillar/slimelink/skript/effects/EffCloneWorld\n*L\n111#1:163,3\n*E\n"})
public final class EffCloneWorld
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<String> sourceWorldName;
    private Expression<String> targetWorldName;
    private boolean isNewSource;
    @Nullable
    private Expression<SlimeLoaderTypeEnum> loaderType;
    @Nullable
    private Boolean isReadOnly;

    @Nullable
    public String toString(@Nullable Event event, boolean debug) {
        Expression<String> expression = this.sourceWorldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sourceWorldName");
            expression = null;
        }
        String source = expression.toString(event, debug);
        Expression<String> expression2 = this.targetWorldName;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("targetWorldName");
            expression2 = null;
        }
        String target = expression2.toString(event, debug);
        Object object = this.loaderType;
        if (object == null || (object = object.toString(event, debug)) == null) {
            object = "";
        }
        Object loader = object;
        return "Clone slime world from " + source + " to " + target + " " + (String)(this.isNewSource ? "with data source " + loader : "");
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.sourceWorldName = expression;
        Expression<?> expression2 = expressions[1];
        Intrinsics.checkNotNull(expression2, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.targetWorldName = expression2;
        boolean bl = this.isNewSource = matchedPattern == 0;
        if (expressions.length > 2 && expressions[2] != null) {
            Expression<?> expression3 = expressions[2];
            Intrinsics.checkNotNull(expression3, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum>");
            this.loaderType = expression3;
        }
        SkriptParser.ParseResult parseResult2 = parseResult;
        this.isReadOnly = parseResult2 != null ? Boolean.valueOf(parseResult2.hasTag("readonly")) : null;
        return true;
    }

    protected void execute(@Nullable Event event) {
        SlimeLoaderTypeEnum slimeLoaderTypeEnum;
        Expression<String> expression = this.sourceWorldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sourceWorldName");
            expression = null;
        }
        String string = (String)expression.getSingle(event);
        if (string == null) {
            return;
        }
        String sourceName = string;
        Expression<String> expression2 = this.targetWorldName;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("targetWorldName");
            expression2 = null;
        }
        String string2 = (String)expression2.getSingle(event);
        if (string2 == null) {
            return;
        }
        String targetName = string2;
        if (this.isNewSource) {
            Expression<SlimeLoaderTypeEnum> expression3 = this.loaderType;
            slimeLoaderTypeEnum = expression3 != null ? (SlimeLoaderTypeEnum)((Object)expression3.getSingle(event)) : null;
        } else {
            slimeLoaderTypeEnum = null;
        }
        SlimeLoaderTypeEnum loader = slimeLoaderTypeEnum;
        try {
            SlimeWorldUtils.INSTANCE.validateWorldName(sourceName);
            SlimeWorldUtils.INSTANCE.validateWorldName(targetName);
            SlimeWorldUtils.requireWorldNotLoaded$default(SlimeWorldUtils.INSTANCE, targetName, null, 2, null);
            WorldData sourceWorldData = SlimeWorldUtils.requireWorldDataExists$default(SlimeWorldUtils.INSTANCE, sourceName, null, 2, null);
            if (StringsKt.equals(sourceName, targetName, true)) {
                throw new IllegalArgumentException("Source and target world names must be different");
            }
            SlimeLoaderTypeEnum slimeLoaderTypeEnum2 = SlimeLoaderTypeEnum.Companion.fromId(sourceWorldData.getSource());
            Intrinsics.checkNotNull((Object)slimeLoaderTypeEnum2);
            SlimeLoader sourceWorldLoader = SlimeWorldUtils.requireLoader$default(SlimeWorldUtils.INSTANCE, slimeLoaderTypeEnum2, null, 2, null);
            SlimeLoader datasource = loader == null ? sourceWorldLoader : SlimeWorldUtils.requireLoader$default(SlimeWorldUtils.INSTANCE, loader, null, 2, null);
            Boolean bl = this.isReadOnly;
            sourceWorldData.setReadOnly(bl != null ? bl.booleanValue() : sourceWorldData.isReadOnly());
            BukkitTask bukkitTask = Bukkit.getScheduler().runTaskAsynchronously((Plugin)SlimeLink.Companion.getInstance(), () -> EffCloneWorld.execute$lambda$0(sourceName, targetName, datasource, sourceWorldData));
            Intrinsics.checkNotNull(bukkitTask);
        }
        catch (SlimeException slime) {
            SlimeException slimeException = slime;
            if (slimeException instanceof WorldAlreadyExistsException) {
                Skript.error((String)("Failed to clone world '" + sourceName + "' to '" + targetName + "'. World already exists"));
                slime.printStackTrace();
            } else if (slimeException instanceof CorruptedWorldException) {
                Skript.error((String)("Failed to clone world '" + sourceName + "' to '" + targetName + "'. World is corrupted"));
                slime.printStackTrace();
            } else if (slimeException instanceof NewerFormatException) {
                Skript.error((String)("Failed to clone world '" + sourceName + "' to '" + targetName + "'. World is in a newer format"));
                slime.printStackTrace();
            } else if (slimeException instanceof UnknownWorldException) {
                Skript.error((String)("Failed to clone world '" + sourceName + "' to '" + targetName + "'. World is unknown"));
                slime.printStackTrace();
            } else {
                Skript.error((String)("Failed to clone world '" + sourceName + "' to '" + targetName + "': " + slime.getMessage()));
                slime.printStackTrace();
            }
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
        }
    }

    private static final void execute$lambda$0(String $sourceName, String $targetName, SlimeLoader $datasource, WorldData $sourceWorldData) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        SlimeWorld slimeWorld = SlimeLink.Companion.getASP().readWorld($datasource, $sourceName, $sourceWorldData.isReadOnly(), $sourceWorldData.toPropertyMap());
        SlimeWorld clonedSlimeWorld = slimeWorld.clone($targetName, $datasource);
        Bukkit.getScheduler().runTask((Plugin)SlimeLink.Companion.getInstance(), () -> EffCloneWorld.execute$lambda$0$0$0(clonedSlimeWorld, $targetName, $sourceWorldData));
        long time = System.currentTimeMillis() - start$iv;
        Skript.info((String)("Cloned world '" + $sourceName + "' to '" + $targetName + "' in " + time + " ms"));
    }

    private static final void execute$lambda$0$0$0(SlimeWorld $clonedSlimeWorld, String $targetName, WorldData $sourceWorldData) {
        SlimeLink.Companion.getASP().loadWorld($clonedSlimeWorld, true);
        ConfigManager.INSTANCE.getWorldConfig().setWorld($targetName, $sourceWorldData);
        ConfigManager.INSTANCE.saveWorldConfig();
    }

    static {
        String[] stringArray = new String[]{"clone (slimeworld|slime world) from %string% to %string% [readonly:as ReadOnly] [newsource: with [datasource|data source] %-slimeloader%]"};
        Skript.registerEffect(EffCloneWorld.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffCloneWorld$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

