/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.exceptions.InvalidWorldException;
import com.infernalsuite.asp.api.exceptions.SlimeException;
import com.infernalsuite.asp.api.exceptions.WorldAlreadyExistsException;
import com.infernalsuite.asp.api.exceptions.WorldLoadedException;
import com.infernalsuite.asp.api.exceptions.WorldTooBigException;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Import SlimeWorld")
@Description(value={"Import a vanilla world as a SlimeWorld.", "Default Slime Properties values will be used for the imported world."})
@Examples(value={})
@Since(value={"1.1.2"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J?\u0010\u000f\u001a\u00020\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffImportWorld;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "vanillaWorldPath", "Lch/njol/skript/lang/Expression;", "", "slimeWorldName", "loaderType", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "execute", "", "Companion", "SlimeLink"})
public final class EffImportWorld
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<String> vanillaWorldPath;
    private Expression<String> slimeWorldName;
    private Expression<SlimeLoaderTypeEnum> loaderType;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<String> expression = this.vanillaWorldPath;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("vanillaWorldPath");
            expression = null;
        }
        String path = expression.toString(event, debug);
        Expression<String> expression2 = this.slimeWorldName;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeWorldName");
            expression2 = null;
        }
        String name = expression2.toString(event, debug);
        Expression<SlimeLoaderTypeEnum> expression3 = this.loaderType;
        if (expression3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression3 = null;
        }
        String loader = expression3.toString(event, debug);
        return "Import world with path " + path + " as slimeworld named " + name + " with datasource " + loader;
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.vanillaWorldPath = expression;
        Expression<?> expression2 = expressions[1];
        Intrinsics.checkNotNull(expression2, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.slimeWorldName = expression2;
        Expression<?> expression3 = expressions[2];
        Intrinsics.checkNotNull(expression3, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum>");
        this.loaderType = expression3;
        return true;
    }

    protected void execute(@Nullable Event event) {
        Expression<String> expression = this.vanillaWorldPath;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("vanillaWorldPath");
            expression = null;
        }
        String string = (String)expression.getSingle(event);
        if (string == null) {
            return;
        }
        String sourcePath = string;
        Expression<String> expression2 = this.slimeWorldName;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeWorldName");
            expression2 = null;
        }
        String string2 = (String)expression2.getSingle(event);
        if (string2 == null) {
            return;
        }
        String targetName = string2;
        Expression<SlimeLoaderTypeEnum> expression3 = this.loaderType;
        if (expression3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression3 = null;
        }
        SlimeLoaderTypeEnum slimeLoaderTypeEnum = (SlimeLoaderTypeEnum)((Object)expression3.getSingle(event));
        if (slimeLoaderTypeEnum == null) {
            return;
        }
        SlimeLoaderTypeEnum loaderType = slimeLoaderTypeEnum;
        try {
            SlimeLoader loader = SlimeWorldUtils.requireLoader$default(SlimeWorldUtils.INSTANCE, loaderType, null, 2, null);
            SlimeWorldUtils.INSTANCE.validateWorldName(targetName);
            SlimeWorldUtils.requireWorldDataNotExists$default(SlimeWorldUtils.INSTANCE, targetName, null, 2, null);
            SlimeWorldUtils.requireWorldNotExists$default(SlimeWorldUtils.INSTANCE, targetName, null, 2, null);
            File worldDir = new File(sourcePath);
            if (!worldDir.exists() || !worldDir.isDirectory()) {
                throw new IllegalArgumentException("The specified world path does not exist or is not a directory: " + sourcePath);
            }
            SlimeWorldUtils.INSTANCE.importSlimeWorldFromVanillaWorld(worldDir, targetName, loaderType, loader);
        }
        catch (SlimeException slime) {
            SlimeException slimeException = slime;
            if (slimeException instanceof WorldAlreadyExistsException) {
                Skript.error((String)("Failed to import vanilla world at '" + sourcePath + "' to '" + targetName + "'. World already exists"));
                slime.printStackTrace();
            } else if (slimeException instanceof InvalidWorldException) {
                Skript.error((String)("Failed to import vanilla world at '" + sourcePath + "' to '" + targetName + "'. World is invalid"));
                slime.printStackTrace();
            } else if (slimeException instanceof WorldLoadedException) {
                Skript.error((String)("Failed to import vanilla world at '" + sourcePath + "' to '" + targetName + "'. World is loaded"));
                slime.printStackTrace();
            } else if (slimeException instanceof WorldTooBigException) {
                Skript.error((String)("Failed to import vanilla world at '" + sourcePath + "' to '" + targetName + "'. World is too big"));
                slime.printStackTrace();
            } else {
                Skript.error((String)("An unknown error occurred while importing vanilla world at '" + sourcePath + "' to '" + targetName + "': " + slime.getMessage()));
                slime.printStackTrace();
            }
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"import world with path %string% as (slimeworld|slime world) named %string% with [datasource|data source] %slimeloader%"};
        Skript.registerEffect(EffImportWorld.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffImportWorld$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

