/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.exceptions.CorruptedWorldException;
import com.infernalsuite.asp.api.exceptions.NewerFormatException;
import com.infernalsuite.asp.api.exceptions.SlimeException;
import com.infernalsuite.asp.api.exceptions.UnknownWorldException;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import dev.danielmillar.slimelink.config.WorldData;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Load Slime World")
@Description(value={"This effect allows you to load a specific SlimeWorld.", "The world must be created before it can be loaded."})
@Examples(value={"load slimeworld named \"MyWorld\"", "load slime world named \"MyWorld\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J?\u0010\f\u001a\u00020\u000b2\u0014\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffLoadSlimeWorld;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "worldName", "Lch/njol/skript/lang/Expression;", "", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "execute", "", "Companion", "SlimeLink"})
public final class EffLoadSlimeWorld
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<String> worldName;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        return "Load slime world " + expression.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.worldName = expression;
        return true;
    }

    protected void execute(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        String string = (String)expression.getSingle(event);
        if (string == null) {
            return;
        }
        String worldNameValue = string;
        try {
            SlimeWorldUtils.INSTANCE.validateWorldName(worldNameValue);
            SlimeWorldUtils.requireWorldNotLoaded$default(SlimeWorldUtils.INSTANCE, worldNameValue, null, 2, null);
            WorldData worldData = SlimeWorldUtils.requireWorldDataExists$default(SlimeWorldUtils.INSTANCE, worldNameValue, null, 2, null);
            SlimeLoaderTypeEnum slimeLoaderTypeEnum = SlimeLoaderTypeEnum.Companion.fromId(worldData.getSource());
            Intrinsics.checkNotNull((Object)slimeLoaderTypeEnum);
            SlimeLoader loader = SlimeWorldUtils.requireLoader$default(SlimeWorldUtils.INSTANCE, slimeLoaderTypeEnum, null, 2, null);
            SlimeWorldUtils.INSTANCE.loadWorldAsync(worldNameValue, loader, worldData.isReadOnly(), worldData.toPropertyMap());
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
        }
        catch (IOException io) {
            Skript.error((String)("I/O error while loading world " + worldNameValue + ": " + io.getMessage()));
            io.printStackTrace();
        }
        catch (SlimeException slime) {
            SlimeException slimeException = slime;
            if (slimeException instanceof CorruptedWorldException) {
                Skript.error((String)("Failed to load world " + worldNameValue + ". World seems to be corrupted"));
                slime.printStackTrace();
            }
            if (slimeException instanceof NewerFormatException) {
                Skript.error((String)("Failed to load world " + worldNameValue + ". This world was serialized with a newer version of Slime Format that SWM can't understand"));
                slime.printStackTrace();
            }
            if (slimeException instanceof UnknownWorldException) {
                Skript.error((String)("Failed to load world " + worldNameValue + ". World cannot be found"));
                slime.printStackTrace();
            }
            Skript.error((String)("Failed to load world " + worldNameValue + ": " + slime.getMessage()));
            slime.printStackTrace();
        }
    }

    static {
        String[] stringArray = new String[]{"load (slimeworld|slime world) named %string%"};
        Skript.registerEffect(EffLoadSlimeWorld.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffLoadSlimeWorld$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

