/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.danielmillar.slimelink.config.WorldData;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Save Slime World By Object")
@Description(value={"This effect allows you to save a specific SlimeWorld."})
@Examples(value={"save slimeworld {world}", "save slime world {world}"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J?\u0010\r\u001a\u00020\f2\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffSaveSlimeWorldByObject;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "world", "Lch/njol/skript/lang/Expression;", "Lorg/bukkit/World;", "toString", "", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "execute", "", "Companion", "SlimeLink"})
public final class EffSaveSlimeWorldByObject
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<World> world;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<World> expression = this.world;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("world");
            expression = null;
        }
        return "Save slime world " + expression.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<org.bukkit.World>");
        this.world = expression;
        return true;
    }

    protected void execute(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<World> expression = this.world;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("world");
            expression = null;
        }
        World world = (World)expression.getSingle(event);
        if (world == null) {
            return;
        }
        World bukkitWorld = world;
        String string = bukkitWorld.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String worldNameValue = string;
        try {
            WorldData worldData = SlimeWorldUtils.requireWorldDataExists$default(SlimeWorldUtils.INSTANCE, worldNameValue, null, 2, null);
            if (worldData.isReadOnly()) {
                throw new IllegalArgumentException("World " + worldNameValue + " is read only");
            }
            SlimeWorldUtils.INSTANCE.saveWorldSync(bukkitWorld, worldNameValue, worldData);
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"save (slimeworld|slime world) %world%"};
        Skript.registerEffect(EffSaveSlimeWorldByObject.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffSaveSlimeWorldByObject$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

