/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.world.properties.SlimeProperty;
import com.infernalsuite.asp.api.world.properties.SlimePropertyMap;
import dev.danielmillar.slimelink.slime.SlimePropertiesEnum;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Create Slime Properties")
@Description(value={"This effects creates a default SlimePropertyMap to be used when creating worlds.", "Default values are provided."})
@Examples(value={"set {_slimeProperty} to slime world properties", "set {_slimeProperty} to default slime world properties", "set {_slimeProperty} to new slime world properties", "create slimeworld named \"MyWorld\" with props (new slime world properties) with datasource file"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J9\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\nH\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0094\u0002\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001c"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprCreateSlimeProperties;", "Lch/njol/skript/lang/util/SimpleExpression;", "Lcom/infernalsuite/asp/api/world/properties/SlimePropertyMap;", "<init>", "()V", "toString", "", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "Lch/njol/skript/lang/Expression;", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parser", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "isSingle", "getReturnType", "Ljava/lang/Class;", "get", "(Lorg/bukkit/event/Event;)[Lcom/infernalsuite/asp/api/world/properties/SlimePropertyMap;", "Companion", "SlimeLink"})
@SourceDebugExtension(value={"SMAP\nExprCreateSlimeProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExprCreateSlimeProperties.kt\ndev/danielmillar/slimelink/skript/expressions/ExprCreateSlimeProperties\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1869#2,2:99\n*S KotlinDebug\n*F\n+ 1 ExprCreateSlimeProperties.kt\ndev/danielmillar/slimelink/skript/expressions/ExprCreateSlimeProperties\n*L\n71#1:99,2\n*E\n"})
public final class ExprCreateSlimeProperties
extends SimpleExpression<SlimePropertyMap> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "Create Slime Properties Map";
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Intrinsics.checkNotNullParameter(isDelayed, "isDelayed");
        Intrinsics.checkNotNullParameter(parser, "parser");
        return true;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<SlimePropertyMap> getReturnType() {
        return SlimePropertyMap.class;
    }

    @NotNull
    protected SlimePropertyMap[] get(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        SlimePropertyMap propertyMap = new SlimePropertyMap();
        Iterable $this$forEach$iv = SlimePropertiesEnum.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SlimePropertiesEnum propertyEnum = (SlimePropertiesEnum)((Object)element$iv);
            boolean bl = false;
            switch (propertyEnum.getDataType()) {
                case "String": {
                    SlimeProperty<?, ?> prop;
                    Intrinsics.checkNotNull(propertyEnum.getProp(), "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.String, *>");
                    propertyMap.setValue(prop, prop.getDefaultValue());
                    break;
                }
                case "Integer": {
                    SlimeProperty<?, ?> prop;
                    Intrinsics.checkNotNull(propertyEnum.getProp(), "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Int, *>");
                    propertyMap.setValue(prop, prop.getDefaultValue());
                    break;
                }
                case "Float": {
                    SlimeProperty<?, ?> prop;
                    Intrinsics.checkNotNull(propertyEnum.getProp(), "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Float, *>");
                    propertyMap.setValue(prop, prop.getDefaultValue());
                    break;
                }
                case "Boolean": {
                    SlimeProperty<?, ?> prop;
                    Intrinsics.checkNotNull(propertyEnum.getProp(), "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Boolean, *>");
                    propertyMap.setValue(prop, prop.getDefaultValue());
                }
            }
        }
        SlimePropertyMap[] slimePropertyMapArray = new SlimePropertyMap[]{propertyMap};
        return slimePropertyMapArray;
    }

    static {
        String[] stringArray = new String[]{"[default|new] slime world properties"};
        Skript.registerExpression(ExprCreateSlimeProperties.class, SlimePropertyMap.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprCreateSlimeProperties$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

