/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fetch Loaded Slime Worlds")
@Description(value={"This expressions returns all SlimeWorlds that are currently loaded on the server."})
@Examples(value={"set {loadedSlimeWorlds::*} to all loaded slimeworlds with datasource %file%", "set {loadedSlimeWorlds::*} to all loaded slime worlds with %file%"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J?\u0010\r\u001a\u00020\f2\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0094\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprFetchLoadedSlimeWorlds;", "Lch/njol/skript/lang/util/SimpleExpression;", "", "<init>", "()V", "loaderType", "Lch/njol/skript/lang/Expression;", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parser", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "isSingle", "getReturnType", "Ljava/lang/Class;", "get", "(Lorg/bukkit/event/Event;)[Ljava/lang/String;", "Companion", "SlimeLink"})
@SourceDebugExtension(value={"SMAP\nExprFetchLoadedSlimeWorlds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExprFetchLoadedSlimeWorlds.kt\ndev/danielmillar/slimelink/skript/expressions/ExprFetchLoadedSlimeWorlds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,86:1\n1563#2:87\n1634#2,3:88\n774#2:91\n865#2,2:92\n37#3,2:94\n*S KotlinDebug\n*F\n+ 1 ExprFetchLoadedSlimeWorlds.kt\ndev/danielmillar/slimelink/skript/expressions/ExprFetchLoadedSlimeWorlds\n*L\n77#1:87\n77#1:88,3\n79#1:91\n79#1:92,2\n79#1:94,2\n*E\n"})
public final class ExprFetchLoadedSlimeWorlds
extends SimpleExpression<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<SlimeLoaderTypeEnum> loaderType;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<SlimeLoaderTypeEnum> expression = this.loaderType;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression = null;
        }
        return "Fetching all loaded slime worlds with datasource " + expression.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parser) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum>");
        this.loaderType = expression;
        return true;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<String> getReturnType() {
        return String.class;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String[] get(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<SlimeLoaderTypeEnum> expression = this.loaderType;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression = null;
        }
        SlimeLoaderTypeEnum slimeLoaderTypeEnum = (SlimeLoaderTypeEnum)((Object)expression.getSingle(event));
        if (slimeLoaderTypeEnum == null) {
            return new String[0];
        }
        SlimeLoaderTypeEnum loaderTypeValue = slimeLoaderTypeEnum;
        try {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            String it;
            Iterable $this$mapTo$iv$iv;
            List list;
            SlimeLoader loader = SlimeWorldUtils.requireLoader$default(SlimeWorldUtils.INSTANCE, loaderTypeValue, null, 2, null);
            try {
                list = loader.listWorlds();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to list worlds from loader " + loaderTypeValue.name() + ": " + ex.getMessage());
            }
            List loaderWorlds = list;
            List list2 = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list2, "getWorlds(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                World world = (World)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            List loadedWorlds = (List)destination$iv$iv;
            Intrinsics.checkNotNull(loaderWorlds);
            Iterable $this$filter$iv = loaderWorlds;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!loadedWorlds.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
            return new String[0];
        }
    }

    static {
        String[] stringArray = new String[]{"all loaded (slimeworlds|slime worlds) with [datasource|data source] %slimeloader%"};
        Skript.registerExpression(ExprFetchLoadedSlimeWorlds.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprFetchLoadedSlimeWorlds$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

