/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Fetch Slime World")
@Description(value={"This expression returns a specific SlimeWorld.", "The world must be loaded for it to be returned."})
@Examples(value={"set {_world} to fetch slimeworld named \"MyWorld\"", "set {_world} to fetch slime world named \"MyWorld\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J?\u0010\r\u001a\u00020\f2\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0094\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprFetchSlimeWorld;", "Lch/njol/skript/lang/util/SimpleExpression;", "Lorg/bukkit/World;", "<init>", "()V", "worldName", "Lch/njol/skript/lang/Expression;", "", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parser", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "isSingle", "getReturnType", "Ljava/lang/Class;", "get", "(Lorg/bukkit/event/Event;)[Lorg/bukkit/World;", "Companion", "SlimeLink"})
public final class ExprFetchSlimeWorld
extends SimpleExpression<World> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<String> worldName;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        return "Fetching " + expression.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parser) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.worldName = expression;
        return true;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<World> getReturnType() {
        return World.class;
    }

    @NotNull
    protected World[] get(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        String string = (String)expression.getSingle(event);
        if (string == null) {
            return new World[0];
        }
        String worldNameValue = string;
        try {
            SlimeWorldUtils.INSTANCE.validateWorldName(worldNameValue);
            World world = Bukkit.getWorld((String)worldNameValue);
            if (world == null) {
                throw new IllegalArgumentException("World " + worldNameValue + " cannot be found");
            }
            World bukkitWorld = world;
            World[] worldArray = new World[]{bukkitWorld};
            return worldArray;
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
            return new World[0];
        }
    }

    static {
        String[] stringArray = new String[]{"fetch (slimeworld|slime world) named %string%"};
        Skript.registerExpression(ExprFetchSlimeWorld.class, World.class, (ExpressionType)ExpressionType.COMBINED, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprFetchSlimeWorld$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

