/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.world.properties.SlimeProperty;
import com.infernalsuite.asp.api.world.properties.SlimePropertyMap;
import dev.danielmillar.slimelink.slime.SlimePropertiesEnum;
import dev.danielmillar.slimelink.util.Util;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Change Slime Properties")
@Description(value={"This expression allows you change properties of an existing SlimePropertyMap.", "A full list of properties are available here: COMING SOON"})
@Examples(value={"set slime property pvp of {_slimeProperty} to true", "set slime property spawn x of {_slimeProperty} to 100"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J7\u0010\u0010\u001a\u00020\u000f2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ1\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010!\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u000fH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0094\u0002\u00a2\u0006\u0002\u0010&R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprModifySlimeProperties;", "Lch/njol/skript/lang/util/SimpleExpression;", "", "<init>", "()V", "slimeProperties", "Lch/njol/skript/lang/Expression;", "Lcom/infernalsuite/asp/api/world/properties/SlimePropertyMap;", "slimePropertyType", "Ldev/danielmillar/slimelink/slime/SlimePropertiesEnum;", "toString", "", "event", "Lorg/bukkit/event/Event;", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parser", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "acceptChange", "Ljava/lang/Class;", "mode", "Lch/njol/skript/classes/Changer$ChangeMode;", "(Lch/njol/skript/classes/Changer$ChangeMode;)[Ljava/lang/Class;", "change", "", "delta", "(Lorg/bukkit/event/Event;[Ljava/lang/Object;Lch/njol/skript/classes/Changer$ChangeMode;)V", "isSingle", "getReturnType", "get", "(Lorg/bukkit/event/Event;)[Ljava/lang/Object;", "Companion", "SlimeLink"})
public final class ExprModifySlimeProperties
extends SimpleExpression<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<SlimePropertyMap> slimeProperties;
    private Expression<SlimePropertiesEnum> slimePropertyType;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<SlimePropertiesEnum> expression = this.slimePropertyType;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimePropertyType");
            expression = null;
        }
        String string = expression.toString(event, debug);
        Expression<SlimePropertyMap> expression2 = this.slimeProperties;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression2 = null;
        }
        return string + " of " + expression2.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Intrinsics.checkNotNullParameter(isDelayed, "isDelayed");
        Intrinsics.checkNotNullParameter(parser, "parser");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimePropertiesEnum>");
        this.slimePropertyType = expression;
        Expression<?> expression2 = expressions[1];
        Intrinsics.checkNotNull(expression2, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<com.infernalsuite.asp.api.world.properties.SlimePropertyMap>");
        this.slimeProperties = expression2;
        return true;
    }

    @NotNull
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        Intrinsics.checkNotNullParameter(mode, "mode");
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1, 2, 3 -> {
                Class[] var2_2 = new Class[]{Object.class};
                yield var2_2;
            }
            default -> {
                Skript.error((String)("Cannot " + mode + " a property type"));
                yield new Class[]{};
            }
        };
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(mode, "mode");
        Expression<SlimePropertyMap> expression = this.slimeProperties;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression = null;
        }
        SlimePropertyMap slimePropertyMap = (SlimePropertyMap)expression.getSingle(event);
        if (slimePropertyMap == null) {
            ExprModifySlimeProperties $this$change_u24lambda_u240 = this;
            boolean bl = false;
            Skript.error((String)"Provided slime properties is null");
            return;
        }
        SlimePropertyMap properties = slimePropertyMap;
        Expression<SlimePropertiesEnum> expression2 = this.slimePropertyType;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimePropertyType");
            expression2 = null;
        }
        SlimePropertiesEnum slimePropertiesEnum = (SlimePropertiesEnum)((Object)expression2.getSingle(event));
        if (slimePropertiesEnum == null) {
            ExprModifySlimeProperties $this$change_u24lambda_u241 = this;
            boolean bl = false;
            Skript.error((String)"Slime property is null");
            return;
        }
        SlimePropertiesEnum property = slimePropertiesEnum;
        if (delta == null || delta.length == 0) {
            Skript.error((String)"No value provided");
            return;
        }
        Object object = delta[0];
        if (object == null) {
            ExprModifySlimeProperties $this$change_u24lambda_u242 = this;
            boolean bl = false;
            Skript.error((String)"Provided value is null");
            return;
        }
        Object value = object;
        switch (property.getDataType()) {
            case "String": {
                SlimeProperty<?, ?> slimeProperty = property.getProp();
                Intrinsics.checkNotNull(slimeProperty, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.String, *>");
                SlimeProperty<?, ?> prop = slimeProperty;
                if (mode == Changer.ChangeMode.SET) {
                    properties.setValue(prop, (Object)value.toString());
                    break;
                }
                Skript.error((String)"Can only SET string properties, not ADD or REMOVE");
                break;
            }
            case "Integer": {
                SlimeProperty<?, ?> slimeProperty = property.getProp();
                Intrinsics.checkNotNull(slimeProperty, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Int, *>");
                SlimeProperty<?, ?> prop = slimeProperty;
                Integer n = Util.INSTANCE.anyToInt(value);
                if (n == null) {
                    ExprModifySlimeProperties $this$change_u24lambda_u243 = this;
                    boolean bl = false;
                    Skript.error((String)("Expected an Int value for property " + property.name() + " but got " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + " instead"));
                    return;
                }
                int convertedValue = n;
                switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                    case 1: {
                        properties.setValue(prop, (Object)convertedValue);
                        break;
                    }
                    case 2: {
                        properties.setValue(prop, (Object)(((Number)properties.getValue(prop)).intValue() + convertedValue));
                        break;
                    }
                    case 3: {
                        properties.setValue(prop, (Object)(((Number)properties.getValue(prop)).intValue() - convertedValue));
                    }
                }
                break;
            }
            case "Float": {
                SlimeProperty<?, ?> slimeProperty = property.getProp();
                Intrinsics.checkNotNull(slimeProperty, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Float, *>");
                SlimeProperty<?, ?> prop = slimeProperty;
                Float f = Util.INSTANCE.anyToFloat(value);
                if (f == null) {
                    ExprModifySlimeProperties $this$change_u24lambda_u244 = this;
                    boolean bl = false;
                    Skript.error((String)("Expected a Float value for property " + property.name() + " but got " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + " instead"));
                    return;
                }
                float convertedValue = f.floatValue();
                switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                    case 1: {
                        properties.setValue(prop, (Object)Float.valueOf(convertedValue));
                        break;
                    }
                    case 2: {
                        properties.setValue(prop, (Object)Float.valueOf(((Number)properties.getValue(prop)).floatValue() + convertedValue));
                        break;
                    }
                    case 3: {
                        properties.setValue(prop, (Object)Float.valueOf(((Number)properties.getValue(prop)).floatValue() - convertedValue));
                    }
                }
                break;
            }
            case "Boolean": {
                SlimeProperty<?, ?> slimeProperty = property.getProp();
                Intrinsics.checkNotNull(slimeProperty, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Boolean, *>");
                SlimeProperty<?, ?> prop = slimeProperty;
                if (mode == Changer.ChangeMode.SET) {
                    Boolean bl = Util.INSTANCE.anyToBoolean(value);
                    if (bl == null) {
                        ExprModifySlimeProperties $this$change_u24lambda_u245 = this;
                        boolean bl2 = false;
                        Skript.error((String)("Expected a Boolean value for property " + property.name() + " but got " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + " instead"));
                        return;
                    }
                    boolean convertedValue = bl;
                    properties.setValue(prop, (Object)convertedValue);
                    break;
                }
                Skript.error((String)"Can only SET boolean properties, not ADD or REMOVE");
                break;
            }
            default: {
                Skript.error((String)("Unknown property data type: " + property.getDataType()));
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<Object> getReturnType() {
        return Object.class;
    }

    @NotNull
    protected Object[] get(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<SlimePropertyMap> expression = this.slimeProperties;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression = null;
        }
        SlimePropertyMap slimePropertyMap = (SlimePropertyMap)expression.getSingle(event);
        if (slimePropertyMap == null) {
            return new Object[0];
        }
        SlimePropertyMap properties = slimePropertyMap;
        Expression<SlimePropertiesEnum> expression2 = this.slimePropertyType;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimePropertyType");
            expression2 = null;
        }
        SlimePropertiesEnum slimePropertiesEnum = (SlimePropertiesEnum)((Object)expression2.getSingle(event));
        if (slimePropertiesEnum == null) {
            return new Object[0];
        }
        SlimePropertiesEnum property = slimePropertiesEnum;
        return switch (property.getDataType()) {
            case "String" -> {
                SlimeProperty<?, ?> v4 = property.getProp();
                Intrinsics.checkNotNull(v4, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.String, *>");
                SlimeProperty<?, ?> prop = v4;
                Object[] var6_9 = new Object[1];
                Intrinsics.checkNotNullExpressionValue(properties.getValue(prop), "getValue(...)");
                yield var6_9;
            }
            case "Integer" -> {
                SlimeProperty<?, ?> v6 = property.getProp();
                Intrinsics.checkNotNull(v6, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Int, *>");
                SlimeProperty<?, ?> prop = v6;
                Object[] var6_10 = new Object[1];
                Intrinsics.checkNotNullExpressionValue(properties.getValue(prop), "getValue(...)");
                yield var6_10;
            }
            case "Float" -> {
                SlimeProperty<?, ?> v7 = property.getProp();
                Intrinsics.checkNotNull(v7, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Float, *>");
                SlimeProperty<?, ?> prop = v7;
                Object[] var6_11 = new Object[1];
                Intrinsics.checkNotNullExpressionValue(properties.getValue(prop), "getValue(...)");
                yield var6_11;
            }
            case "Boolean" -> {
                SlimeProperty<?, ?> v8 = property.getProp();
                Intrinsics.checkNotNull(v8, "null cannot be cast to non-null type com.infernalsuite.asp.api.world.properties.SlimeProperty<kotlin.Boolean, *>");
                SlimeProperty<?, ?> prop = v8;
                Object[] var6_12 = new Object[1];
                Intrinsics.checkNotNullExpressionValue(properties.getValue(prop), "getValue(...)");
                yield var6_12;
            }
            default -> {
                Skript.error((String)("Unknown property data type: " + property.getDataType()));
                yield new Object[]{};
            }
        };
    }

    static {
        String[] stringArray = new String[]{"slime property %slimeproperty% of %slimepropertymap%"};
        Skript.registerExpression(ExprModifySlimeProperties.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/expressions/ExprModifySlimeProperties$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Changer.ChangeMode.values().length];
            try {
                nArray[Changer.ChangeMode.SET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Changer.ChangeMode.ADD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Changer.ChangeMode.REMOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

