/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.slime;

import com.infernalsuite.asp.api.loaders.SlimeLoader;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/danielmillar/slimelink/slime/SlimeManager;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "loaders", "", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "Lcom/infernalsuite/asp/api/loaders/SlimeLoader;", "registerLoader", "", "type", "getLoader", "unregisterLoader", "registeredTypes", "", "SlimeLink"})
public final class SlimeManager {
    @NotNull
    public static final SlimeManager INSTANCE = new SlimeManager();
    private static final Logger logger = LoggerFactory.getLogger(SlimeManager.class);
    @NotNull
    private static final Map<SlimeLoaderTypeEnum, SlimeLoader> loaders = new LinkedHashMap();

    private SlimeManager() {
    }

    public final boolean registerLoader(@NotNull SlimeLoaderTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        if (loaders.containsKey((Object)type)) {
            logger.info("Loader for " + type.name() + " is already registered. Skipping re-registration.");
            return true;
        }
        try {
            loaders.put(type, type.createLoader());
            return true;
        }
        catch (Exception ex) {
            logger.error("Failed to register loader for " + type.name(), ex);
            return false;
        }
    }

    @Nullable
    public final SlimeLoader getLoader(@NotNull SlimeLoaderTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        return loaders.get((Object)type);
    }

    public final boolean unregisterLoader(@NotNull SlimeLoaderTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        return loaders.remove((Object)type) != null;
    }

    @NotNull
    public final Set<SlimeLoaderTypeEnum> registeredTypes() {
        return loaders.keySet();
    }
}

