/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.util;

import ch.njol.skript.Skript;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import com.infernalsuite.asp.api.world.SlimeWorld;
import com.infernalsuite.asp.api.world.properties.SlimePropertyMap;
import dev.danielmillar.slimelink.SlimeLink;
import dev.danielmillar.slimelink.config.ConfigManager;
import dev.danielmillar.slimelink.config.WorldData;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.slime.SlimeManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\n\u001a\u00020\u0007J.\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0012J\u0016\u0010\"\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0012J\u001e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0010J\u001e\u0010&\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0010J0\u0010(\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+J&\u0010,\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+\u00a8\u0006-"}, d2={"Ldev/danielmillar/slimelink/util/SlimeWorldUtils;", "", "<init>", "()V", "validateWorldName", "", "name", "", "requireWorldLoaded", "Lorg/bukkit/World;", "message", "requireWorldNotLoaded", "requireWorldNotExists", "requireWorldDataNotExists", "worldName", "requireWorldDataExists", "Ldev/danielmillar/slimelink/config/WorldData;", "requireLoader", "Lcom/infernalsuite/asp/api/loaders/SlimeLoader;", "type", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "createAndLoadWorldAsync", "properties", "Lcom/infernalsuite/asp/api/world/properties/SlimePropertyMap;", "loader", "loaderName", "readOnly", "", "loadWorldAsync", "importSlimeWorldFromVanillaWorld", "vanillaWorldPath", "Ljava/io/File;", "slimeWorldName", "loaderType", "deleteWorldAsync", "saveWorldSync", "worldBukkit", "worldData", "unloadWorldSync", "bukkitWorld", "unloadWithOptionalTeleport", "shouldTeleport", "teleportTarget", "Lorg/bukkit/Location;", "teleportPlayersAndUnloadWorld", "SlimeLink"})
@SourceDebugExtension(value={"SMAP\nSlimeWorldUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlimeWorldUtils.kt\ndev/danielmillar/slimelink/util/SlimeWorldUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,382:1\n1#2:383\n1563#3:384\n1634#3,3:385\n37#4,2:388\n29#5,3:390\n29#5,3:393\n29#5,3:396\n29#5,3:399\n29#5,3:402\n*S KotlinDebug\n*F\n+ 1 SlimeWorldUtils.kt\ndev/danielmillar/slimelink/util/SlimeWorldUtils\n*L\n372#1:384\n372#1:385,3\n372#1:388,2\n146#1:390,3\n184#1:393,3\n212#1:396,3\n241#1:399,3\n265#1:402,3\n*E\n"})
public final class SlimeWorldUtils {
    @NotNull
    public static final SlimeWorldUtils INSTANCE = new SlimeWorldUtils();

    private SlimeWorldUtils() {
    }

    public final void validateWorldName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        CharSequence charSequence = name;
        if (!new Regex("^[a-z0-9/._-]+$").matches(charSequence)) {
            boolean bl = false;
            String string = "World name '" + name + "' is invalid. Only lowercase letters, numbers, hyphens, underscores, periods, and slashes are allowed.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final World requireWorldLoaded(@NotNull String name, @NotNull String message) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(message, "message");
        World world = Bukkit.getWorld((String)name);
        if (world == null) {
            boolean bl = false;
            String string = message;
            throw new IllegalArgumentException(string.toString());
        }
        return world;
    }

    public static /* synthetic */ World requireWorldLoaded$default(SlimeWorldUtils slimeWorldUtils, String string, String object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = "World '" + string + "' is not loaded";
        }
        return slimeWorldUtils.requireWorldLoaded(string, (String)object);
    }

    public final void requireWorldNotLoaded(@NotNull String name, @NotNull String message) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(message, "message");
        if (!(Bukkit.getWorld((String)name) == null)) {
            boolean bl = false;
            String string = message;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void requireWorldNotLoaded$default(SlimeWorldUtils slimeWorldUtils, String string, String object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = "World '" + string + "' is already loaded!";
        }
        slimeWorldUtils.requireWorldNotLoaded(string, (String)object);
    }

    public final void requireWorldNotExists(@NotNull String name, @NotNull String message) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(message, "message");
        if (!(Bukkit.getWorld((String)name) == null)) {
            boolean bl = false;
            String string = message;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void requireWorldNotExists$default(SlimeWorldUtils slimeWorldUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "A loaded world with that name already exists!";
        }
        slimeWorldUtils.requireWorldNotExists(string, string2);
    }

    public final void requireWorldDataNotExists(@NotNull String worldName, @NotNull String message) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(message, "message");
        WorldData worldData = ConfigManager.INSTANCE.getWorldConfig().getWorld(worldName);
        if (!(worldData == null)) {
            boolean bl = false;
            String string = message;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void requireWorldDataNotExists$default(SlimeWorldUtils slimeWorldUtils, String string, String object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = "World " + string + " already exists in config";
        }
        slimeWorldUtils.requireWorldDataNotExists(string, (String)object);
    }

    @NotNull
    public final WorldData requireWorldDataExists(@NotNull String worldName, @NotNull String message) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(message, "message");
        WorldData worldData = ConfigManager.INSTANCE.getWorldConfig().getWorld(worldName);
        if (worldData == null) {
            boolean bl = false;
            String string = message;
            throw new IllegalArgumentException(string.toString());
        }
        return worldData;
    }

    public static /* synthetic */ WorldData requireWorldDataExists$default(SlimeWorldUtils slimeWorldUtils, String string, String object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = "World " + string + " cannot be found in config";
        }
        return slimeWorldUtils.requireWorldDataExists(string, (String)object);
    }

    @NotNull
    public final SlimeLoader requireLoader(@NotNull SlimeLoaderTypeEnum type, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(message, "message");
        SlimeLoader slimeLoader = SlimeManager.INSTANCE.getLoader(type);
        if (slimeLoader == null) {
            boolean bl = false;
            String string = message;
            throw new IllegalArgumentException(string.toString());
        }
        return slimeLoader;
    }

    public static /* synthetic */ SlimeLoader requireLoader$default(SlimeWorldUtils slimeWorldUtils, SlimeLoaderTypeEnum slimeLoaderTypeEnum, String object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = "Loader '" + slimeLoaderTypeEnum.name() + "' is not registered. Please initialize it first.";
        }
        return slimeWorldUtils.requireLoader(slimeLoaderTypeEnum, (String)object);
    }

    public final void createAndLoadWorldAsync(@NotNull String worldName, @NotNull SlimePropertyMap properties, @NotNull SlimeLoader loader, @NotNull String loaderName, boolean readOnly2) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(properties, "properties");
        Intrinsics.checkNotNullParameter(loader, "loader");
        Intrinsics.checkNotNullParameter(loaderName, "loaderName");
        SlimeLink plugin = SlimeLink.Companion.getInstance();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> SlimeWorldUtils.createAndLoadWorldAsync$lambda$0(worldName, readOnly2, properties, loader, plugin, loaderName));
    }

    public final void loadWorldAsync(@NotNull String worldName, @NotNull SlimeLoader loader, boolean readOnly2, @NotNull SlimePropertyMap properties) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(loader, "loader");
        Intrinsics.checkNotNullParameter(properties, "properties");
        SlimeLink plugin = SlimeLink.Companion.getInstance();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> SlimeWorldUtils.loadWorldAsync$lambda$0(worldName, loader, readOnly2, properties, plugin));
    }

    public final void importSlimeWorldFromVanillaWorld(@NotNull File vanillaWorldPath, @NotNull String slimeWorldName, @NotNull SlimeLoaderTypeEnum loaderType, @NotNull SlimeLoader loader) {
        Intrinsics.checkNotNullParameter(vanillaWorldPath, "vanillaWorldPath");
        Intrinsics.checkNotNullParameter(slimeWorldName, "slimeWorldName");
        Intrinsics.checkNotNullParameter((Object)loaderType, "loaderType");
        Intrinsics.checkNotNullParameter(loader, "loader");
        SlimeLink plugin = SlimeLink.Companion.getInstance();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> SlimeWorldUtils.importSlimeWorldFromVanillaWorld$lambda$0(slimeWorldName, vanillaWorldPath, loader, plugin, loaderType));
    }

    public final void deleteWorldAsync(@NotNull String worldName, @NotNull SlimeLoader loader) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(loader, "loader");
        SlimeLink plugin = SlimeLink.Companion.getInstance();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> SlimeWorldUtils.deleteWorldAsync$lambda$0(worldName, loader));
    }

    public final void saveWorldSync(@NotNull World worldBukkit, @NotNull String worldName, @NotNull WorldData worldData) {
        Intrinsics.checkNotNullParameter(worldBukkit, "worldBukkit");
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(worldData, "worldData");
        SlimeLink plugin = SlimeLink.Companion.getInstance();
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> SlimeWorldUtils.saveWorldSync$lambda$0(worldName, worldBukkit, worldData));
    }

    public final void unloadWorldSync(@NotNull String worldName, @NotNull World bukkitWorld, @NotNull WorldData worldData) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(bukkitWorld, "bukkitWorld");
        Intrinsics.checkNotNullParameter(worldData, "worldData");
        SlimeLink plugin = SlimeLink.Companion.getInstance();
        Ref.IntRef attempts = new Ref.IntRef();
        int maxAttempts = 10;
        new BukkitRunnable(attempts, maxAttempts, worldName, worldData, bukkitWorld){
            final /* synthetic */ Ref.IntRef $attempts;
            final /* synthetic */ int $maxAttempts;
            final /* synthetic */ String $worldName;
            final /* synthetic */ WorldData $worldData;
            final /* synthetic */ World $bukkitWorld;
            {
                this.$attempts = $attempts;
                this.$maxAttempts = $maxAttempts;
                this.$worldName = $worldName;
                this.$worldData = $worldData;
                this.$bukkitWorld = $bukkitWorld;
            }

            public void run() {
                if (Bukkit.isTickingWorlds()) {
                    ++this.$attempts.element;
                    if (this.$attempts.element >= this.$maxAttempts) {
                        Skript.error((String)("Failed to unload world '" + this.$worldName + "' after waiting for ticking to stop."));
                        this.cancel();
                    }
                    return;
                }
                this.cancel();
                boolean success = false;
                WorldData worldData = this.$worldData;
                World world = this.$bukkitWorld;
                String string = this.$worldName;
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                if (worldData.isReadOnly()) {
                    success = Bukkit.unloadWorld((World)world, (boolean)false);
                } else {
                    ConfigManager.INSTANCE.getWorldConfig().setWorld(string, worldData);
                    ConfigManager.INSTANCE.saveWorldConfig();
                    success = Bukkit.unloadWorld((World)world, (boolean)true);
                }
                long time = System.currentTimeMillis() - start$iv;
                if (success) {
                    Skript.info((String)("Successfully unloaded world '" + this.$worldName + "' in " + time + "ms"));
                } else {
                    Skript.error((String)("Failed to unload world '" + this.$worldName + "' in " + time + "ms, it may still be loaded"));
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 5L);
    }

    public final void unloadWithOptionalTeleport(@NotNull String worldName, @NotNull World bukkitWorld, @NotNull WorldData worldData, boolean shouldTeleport, @Nullable Location teleportTarget) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(bukkitWorld, "bukkitWorld");
        Intrinsics.checkNotNullParameter(worldData, "worldData");
        List list = bukkitWorld.getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        List players = list;
        if (players.isEmpty()) {
            this.unloadWorldSync(worldName, bukkitWorld, worldData);
            return;
        }
        if (!shouldTeleport) {
            boolean $i$a$-require-SlimeWorldUtils$unloadWithOptionalTeleport$22 = false;
            String $i$a$-require-SlimeWorldUtils$unloadWithOptionalTeleport$22 = "Players in world '" + worldName + "'; cannot unload without removing them";
            throw new IllegalArgumentException($i$a$-require-SlimeWorldUtils$unloadWithOptionalTeleport$22.toString());
        }
        Location location = teleportTarget;
        if (location == null) {
            boolean bl = false;
            String string = "Teleport target location is null, unable to unload world '" + worldName + "'";
            throw new IllegalArgumentException(string.toString());
        }
        Location target = location;
        this.teleportPlayersAndUnloadWorld(worldName, bukkitWorld, worldData, target);
    }

    /*
     * WARNING - void declaration
     */
    public final void teleportPlayersAndUnloadWorld(@NotNull String worldName, @NotNull World bukkitWorld, @NotNull WorldData worldData, @NotNull Location teleportTarget) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(bukkitWorld, "bukkitWorld");
        Intrinsics.checkNotNullParameter(worldData, "worldData");
        Intrinsics.checkNotNullParameter(teleportTarget, "teleportTarget");
        List list = bukkitWorld.getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        List playersInWorld = list;
        Iterable $this$map$iv = playersInWorld;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.teleportAsync(teleportTarget));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        ((CompletableFuture)completableFuture.thenRun(() -> SlimeWorldUtils.teleportPlayersAndUnloadWorld$lambda$1(worldName, bukkitWorld, worldData))).exceptionally(arg_0 -> SlimeWorldUtils.teleportPlayersAndUnloadWorld$lambda$2(worldName, arg_0));
    }

    private static final void createAndLoadWorldAsync$lambda$0(String $worldName, boolean $readOnly, SlimePropertyMap $properties, SlimeLoader $loader, SlimeLink $plugin, String $loaderName) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        SlimeWorld slimeWorld = SlimeLink.Companion.getASP().createEmptyWorld($worldName, $readOnly, $properties, $loader);
        SlimeLink.Companion.getASP().saveWorld(slimeWorld);
        Bukkit.getScheduler().runTask((Plugin)$plugin, () -> SlimeWorldUtils.createAndLoadWorldAsync$lambda$0$0$0(slimeWorld, $loaderName, $readOnly, $worldName));
        long time = System.currentTimeMillis() - start$iv;
        Skript.info((String)("Successfully created world '" + $worldName + "' in " + time + "ms"));
    }

    private static final void createAndLoadWorldAsync$lambda$0$0$0(SlimeWorld $slimeWorld, String $loaderName, boolean $readOnly, String $worldName) {
        SlimeLink.Companion.getASP().loadWorld($slimeWorld, true);
        WorldData worldData = new WorldData($loaderName, null, null, false, false, false, false, null, null, null, $readOnly, 1022, null);
        ConfigManager.INSTANCE.getWorldConfig().setWorld($worldName, worldData);
        ConfigManager.INSTANCE.saveWorldConfig();
    }

    private static final void loadWorldAsync$lambda$0(String $worldName, SlimeLoader $loader, boolean $readOnly, SlimePropertyMap $properties, SlimeLink $plugin) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        SlimeWorld slimeWorld = SlimeLink.Companion.getASP().readWorld($loader, $worldName, $readOnly, $properties);
        Bukkit.getScheduler().runTask((Plugin)$plugin, () -> SlimeWorldUtils.loadWorldAsync$lambda$0$0$0(slimeWorld));
        long time = System.currentTimeMillis() - start$iv;
        Skript.info((String)("Successfully loaded world '" + $worldName + "' in " + time + "ms"));
    }

    private static final void loadWorldAsync$lambda$0$0$0(SlimeWorld $slimeWorld) {
        SlimeLink.Companion.getASP().loadWorld($slimeWorld, true);
    }

    private static final void importSlimeWorldFromVanillaWorld$lambda$0(String $slimeWorldName, File $vanillaWorldPath, SlimeLoader $loader, SlimeLink $plugin, SlimeLoaderTypeEnum $loaderType) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        SlimeWorld slimeWorld = SlimeLink.Companion.getASP().readVanillaWorld($vanillaWorldPath, $slimeWorldName, $loader);
        SlimeLink.Companion.getASP().saveWorld(slimeWorld);
        Bukkit.getScheduler().runTask((Plugin)$plugin, () -> SlimeWorldUtils.importSlimeWorldFromVanillaWorld$lambda$0$0$0(slimeWorld, $loaderType, $slimeWorldName));
        long time = System.currentTimeMillis() - start$iv;
        Skript.info((String)("Successfully imported world '" + $slimeWorldName + "' from '" + $vanillaWorldPath + "' in " + time + "ms"));
    }

    private static final void importSlimeWorldFromVanillaWorld$lambda$0$0$0(SlimeWorld $slimeWorld, SlimeLoaderTypeEnum $loaderType, String $slimeWorldName) {
        SlimeLink.Companion.getASP().loadWorld($slimeWorld, true);
        WorldData worldData = new WorldData($loaderType.getLoaderId(), null, null, false, false, false, false, null, null, null, false, 1022, null);
        ConfigManager.INSTANCE.getWorldConfig().setWorld($slimeWorldName, worldData);
        ConfigManager.INSTANCE.saveWorldConfig();
    }

    private static final void deleteWorldAsync$lambda$0(String $worldName, SlimeLoader $loader) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        $loader.deleteWorld($worldName);
        ConfigManager.INSTANCE.getWorldConfig().removeWorld($worldName);
        ConfigManager.INSTANCE.saveWorldConfig();
        long time = System.currentTimeMillis() - start$iv;
        Skript.info((String)("Successfully deleted world '" + $worldName + "' in " + time + "ms"));
    }

    private static final void saveWorldSync$lambda$0(String $worldName, World $worldBukkit, WorldData $worldData) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        $worldBukkit.save();
        ConfigManager.INSTANCE.getWorldConfig().setWorld($worldName, $worldData);
        ConfigManager.INSTANCE.saveWorldConfig();
        long time = System.currentTimeMillis() - start$iv;
        Skript.info((String)("Successfully saved world '" + $worldName + "' in " + time + "ms"));
    }

    private static final void teleportPlayersAndUnloadWorld$lambda$1(String $worldName, World $bukkitWorld, WorldData $worldData) {
        INSTANCE.unloadWorldSync($worldName, $bukkitWorld, $worldData);
    }

    private static final Void teleportPlayersAndUnloadWorld$lambda$2(String $worldName, Throwable it) {
        Skript.error((String)("Failed to teleport players and unload world '" + $worldName + "': " + it.getMessage()));
        return null;
    }
}

