/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.slots;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.models.slots.ClusterSlotRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ClusterSlotsParser {
    private ClusterSlotsParser() {
    }

    public static List<ClusterSlotRange> parse(List<?> clusterSlotsOutput) {
        ArrayList<ClusterSlotRange> result = new ArrayList<ClusterSlotRange>();
        HashMap<String, RedisClusterNode> nodeCache = new HashMap<String, RedisClusterNode>();
        for (Object o : clusterSlotsOutput) {
            List range;
            if (!(o instanceof List) || (range = (List)o).size() < 2) continue;
            ClusterSlotRange clusterSlotRange = ClusterSlotsParser.parseRange(range, nodeCache);
            result.add(clusterSlotRange);
        }
        Collections.sort(result, new Comparator<ClusterSlotRange>(){

            @Override
            public int compare(ClusterSlotRange o1, ClusterSlotRange o2) {
                return o1.getFrom() - o2.getFrom();
            }
        });
        return Collections.unmodifiableList(result);
    }

    private static ClusterSlotRange parseRange(List<?> range, Map<String, RedisClusterNode> nodeCache) {
        Iterator<?> iterator2 = range.iterator();
        int from = Math.toIntExact(ClusterSlotsParser.getLongFromIterator(iterator2, 0L));
        int to = Math.toIntExact(ClusterSlotsParser.getLongFromIterator(iterator2, 0L));
        RedisClusterNode upstream = null;
        ArrayList<RedisClusterNode> replicas = new ArrayList<RedisClusterNode>();
        if (iterator2.hasNext() && (upstream = ClusterSlotsParser.getRedisClusterNode(iterator2, nodeCache)) != null) {
            upstream.setFlags(Collections.singleton(RedisClusterNode.NodeFlag.UPSTREAM));
            TreeSet<Integer> slots = new TreeSet<Integer>(upstream.getSlots());
            slots.addAll(ClusterSlotsParser.createSlots(from, to));
            upstream.setSlots(new ArrayList<Integer>(slots));
        }
        while (iterator2.hasNext()) {
            RedisClusterNode replica = ClusterSlotsParser.getRedisClusterNode(iterator2, nodeCache);
            if (replica == null || upstream == null) continue;
            replica.setSlaveOf(upstream.getNodeId());
            replica.setFlags(Collections.singleton(RedisClusterNode.NodeFlag.REPLICA));
            replicas.add(replica);
        }
        return new ClusterSlotRange(from, to, upstream, Collections.unmodifiableList(replicas));
    }

    private static List<Integer> createSlots(int from, int to) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = from; i < to + 1; ++i) {
            slots.add(i);
        }
        return slots;
    }

    private static RedisClusterNode getRedisClusterNode(Iterator<?> iterator2, Map<String, RedisClusterNode> nodeCache) {
        Object element = iterator2.next();
        RedisClusterNode redisClusterNode = null;
        if (element instanceof List) {
            List hostAndPortList = (List)element;
            if (hostAndPortList.size() < 2) {
                return null;
            }
            Iterator hostAndPortIterator = hostAndPortList.iterator();
            String host = (String)hostAndPortIterator.next();
            int port = Math.toIntExact(ClusterSlotsParser.getLongFromIterator(hostAndPortIterator, 0L));
            if (hostAndPortIterator.hasNext()) {
                String nodeId = (String)hostAndPortIterator.next();
                redisClusterNode = nodeCache.get(nodeId);
                if (redisClusterNode == null) {
                    redisClusterNode = ClusterSlotsParser.createNode(host, port);
                    nodeCache.put(nodeId, redisClusterNode);
                    redisClusterNode.setNodeId(nodeId);
                }
            } else {
                String key = host + ":" + port;
                redisClusterNode = nodeCache.get(key);
                if (redisClusterNode == null) {
                    redisClusterNode = ClusterSlotsParser.createNode(host, port);
                    nodeCache.put(key, redisClusterNode);
                }
            }
        }
        return redisClusterNode;
    }

    private static RedisClusterNode createNode(String host, int port) {
        RedisClusterNode redisClusterNode = new RedisClusterNode();
        redisClusterNode.setUri(RedisURI.create(host, port));
        redisClusterNode.setSlots(new ArrayList<Integer>());
        return redisClusterNode;
    }

    private static long getLongFromIterator(Iterator<?> iterator2, long defaultValue) {
        if (iterator2.hasNext()) {
            Object object = iterator2.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }
}

