/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.event.jfr.EventRecorder;
import io.lettuce.core.masterreplica.MasterReplicaChannelWriter;
import io.lettuce.core.masterreplica.MasterReplicaConnectionProvider;
import io.lettuce.core.masterreplica.MasterReplicaConnector;
import io.lettuce.core.masterreplica.MasterReplicaTopologyChangedEvent;
import io.lettuce.core.masterreplica.MasterReplicaTopologyRefresh;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnectionImpl;
import io.lettuce.core.masterreplica.StaticMasterReplicaTopologyProvider;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import reactor.core.publisher.Mono;

class StaticMasterReplicaConnector<K, V>
implements MasterReplicaConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final Iterable<RedisURI> redisURIs;

    StaticMasterReplicaConnector(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURIs = redisURIs;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterReplicaConnection<K, V>> connectAsync() {
        HashMap initialConnections = new HashMap();
        StaticMasterReplicaTopologyProvider topologyProvider = new StaticMasterReplicaTopologyProvider(this.redisClient, this.redisURIs);
        RedisURI seedNode = this.redisURIs.iterator().next();
        MasterReplicaTopologyRefresh refresh = new MasterReplicaTopologyRefresh(this.redisClient, topologyProvider);
        MasterReplicaConnectionProvider<K, V> connectionProvider = new MasterReplicaConnectionProvider<K, V>(this.redisClient, this.codec, seedNode, initialConnections);
        return refresh.getNodes(seedNode).flatMap(nodes -> {
            EventRecorder.getInstance().record(new MasterReplicaTopologyChangedEvent(seedNode, (List<RedisNodeDescription>)nodes));
            if (nodes.isEmpty()) {
                return Mono.error(new RedisException(String.format("Cannot determine topology from %s", this.redisURIs)));
            }
            return this.initializeConnection(this.codec, seedNode, connectionProvider, (List<RedisNodeDescription>)nodes);
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<StatefulRedisMasterReplicaConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, RedisURI seedNode, MasterReplicaConnectionProvider<K, V> connectionProvider, List<RedisNodeDescription> nodes) {
        connectionProvider.setKnownNodes(nodes);
        MasterReplicaChannelWriter channelWriter = new MasterReplicaChannelWriter(connectionProvider, this.redisClient.getResources(), this.redisClient.getOptions());
        StatefulRedisMasterReplicaConnectionImpl<K, V> connection = new StatefulRedisMasterReplicaConnectionImpl<K, V>(channelWriter, codec, seedNode.getTimeout(), this.redisClient.getOptions().getJsonParser());
        connection.setOptions(this.redisClient.getOptions());
        return Mono.just(connection);
    }
}

