/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.MapOutput;
import io.lettuce.core.protocol.BaseRedisCommandBuilder;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.pubsub.PubSubCommandArgs;
import io.lettuce.core.pubsub.PubSubOutput;
import java.util.List;
import java.util.Map;

class PubSubCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    static final String MUST_NOT_BE_EMPTY = "must not be empty";

    PubSubCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    Command<K, V, Long> publish(K channel, V message) {
        CommandArgs args = new PubSubCommandArgs(this.codec).addKey(channel).addValue(message);
        return this.createCommand(CommandType.PUBLISH, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<K>> pubsubChannels(K pattern) {
        CommandArgs args = new PubSubCommandArgs(this.codec).add(CommandKeyword.CHANNELS).addKey(pattern);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, Map<K, Long>> pubsubNumsub(K ... channels) {
        LettuceAssert.notEmpty((Object[])channels, "Channels must not be empty");
        CommandArgs args = new PubSubCommandArgs(this.codec).add(CommandKeyword.NUMSUB).addKeys(channels);
        return this.createCommand(CommandType.PUBSUB, new MapOutput(this.codec), args);
    }

    Command<K, V, List<K>> pubsubShardChannels(K pattern) {
        CommandArgs args = new PubSubCommandArgs(this.codec).add(CommandKeyword.SHARDCHANNELS).addKey(pattern);
        return this.createCommand(CommandType.PUBSUB, new KeyListOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, Map<K, Long>> pubsubShardNumsub(K ... shardChannels) {
        LettuceAssert.notEmpty((Object[])shardChannels, "Shard channels must not be empty");
        CommandArgs args = new PubSubCommandArgs(this.codec).add(CommandKeyword.SHARDNUMSUB).addKeys(shardChannels);
        return this.createCommand(CommandType.PUBSUB, new MapOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, V> psubscribe(K ... patterns) {
        LettuceAssert.notEmpty((Object[])patterns, "Patterns must not be empty");
        return this.pubSubCommand(CommandType.PSUBSCRIBE, new PubSubOutput(this.codec), patterns);
    }

    @SafeVarargs
    final Command<K, V, V> punsubscribe(K ... patterns) {
        return this.pubSubCommand(CommandType.PUNSUBSCRIBE, new PubSubOutput(this.codec), patterns);
    }

    Command<K, V, Long> spublish(K shardChannel, V message) {
        CommandArgs args = new CommandArgs(this.codec).addKey(shardChannel).addValue(message);
        return this.createCommand(CommandType.SPUBLISH, new IntegerOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, V> ssubscribe(K ... shardChannels) {
        LettuceAssert.notEmpty((Object[])shardChannels, "Shard channels must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(shardChannels);
        return this.createCommand(CommandType.SSUBSCRIBE, new PubSubOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, V> subscribe(K ... channels) {
        LettuceAssert.notEmpty((Object[])channels, "Channels must not be empty");
        return this.pubSubCommand(CommandType.SUBSCRIBE, new PubSubOutput(this.codec), channels);
    }

    @SafeVarargs
    final Command<K, V, V> sunsubscribe(K ... shardChannels) {
        LettuceAssert.notEmpty((Object[])shardChannels, "Shard channels must not be empty");
        CommandArgs args = new CommandArgs(this.codec).addKeys(shardChannels);
        return this.createCommand(CommandType.SUNSUBSCRIBE, new PubSubOutput(this.codec), args);
    }

    @SafeVarargs
    final Command<K, V, V> unsubscribe(K ... channels) {
        return this.pubSubCommand(CommandType.UNSUBSCRIBE, new PubSubOutput(this.codec), channels);
    }

    @SafeVarargs
    final <T> Command<K, V, T> pubSubCommand(CommandType type, CommandOutput<K, V, T> output, K ... keys2) {
        return new Command<K, V, T>(type, output, new PubSubCommandArgs(this.codec).addKeys(keys2));
    }
}

