/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionState;
import io.lettuce.core.RedisException;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubMessage;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.resource.ClientResources;
import io.netty.channel.Channel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PubSubEndpoint<K, V>
extends DefaultEndpoint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PubSubEndpoint.class);
    private static final Set<String> ALLOWED_COMMANDS_SUBSCRIBED = new HashSet<String>(6, 1.0f);
    private static final Set<String> SUBSCRIBE_COMMANDS;
    private final List<RedisPubSubListener<K, V>> listeners = new CopyOnWriteArrayList<RedisPubSubListener<K, V>>();
    private final Set<Wrapper<K>> channels = ConcurrentHashMap.newKeySet();
    private final Set<Wrapper<K>> shardChannels;
    private final Set<Wrapper<K>> patterns = ConcurrentHashMap.newKeySet();
    private volatile boolean subscribeWritten = false;
    private ConnectionState connectionState;

    public PubSubEndpoint(ClientOptions clientOptions, ClientResources clientResources) {
        super(clientOptions, clientResources);
        this.shardChannels = ConcurrentHashMap.newKeySet();
    }

    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    protected List<RedisPubSubListener<K, V>> getListeners() {
        return this.listeners;
    }

    public boolean hasChannelSubscriptions() {
        return !this.channels.isEmpty();
    }

    public Set<K> getChannels() {
        return this.unwrap(this.channels);
    }

    public boolean hasShardChannelSubscriptions() {
        return !this.shardChannels.isEmpty();
    }

    public Set<K> getShardChannels() {
        return this.unwrap(this.shardChannels);
    }

    public boolean hasPatternSubscriptions() {
        return !this.patterns.isEmpty();
    }

    public Set<K> getPatterns() {
        return this.unwrap(this.patterns);
    }

    @Override
    public void notifyChannelActive(Channel channel) {
        this.subscribeWritten = false;
        super.notifyChannelActive(channel);
    }

    public <K1, V1, T> RedisCommand<K1, V1, T> write(RedisCommand<K1, V1, T> command) {
        if (this.isSubscribed() && !this.isAllowed(command)) {
            this.rejectCommand(command);
            return command;
        }
        if (!this.subscribeWritten && SUBSCRIBE_COMMANDS.contains(command.getType().toString())) {
            this.subscribeWritten = true;
        }
        return super.write(command);
    }

    public <K1, V1> Collection<RedisCommand<K1, V1, ?>> write(Collection<? extends RedisCommand<K1, V1, ?>> redisCommands) {
        if (this.isSubscribed() && this.containsViolatingCommands(redisCommands)) {
            this.rejectCommands(redisCommands);
            return redisCommands;
        }
        if (!this.subscribeWritten) {
            for (RedisCommand<K1, V1, ?> redisCommand : redisCommands) {
                if (!SUBSCRIBE_COMMANDS.contains(redisCommand.getType().toString())) continue;
                this.subscribeWritten = true;
                break;
            }
        }
        return super.write(redisCommands);
    }

    protected void rejectCommand(RedisCommand<?, ?, ?> command) {
        command.completeExceptionally(new RedisException(String.format("Command %s not allowed while subscribed. Allowed commands are: %s", command.getType().toString(), ALLOWED_COMMANDS_SUBSCRIBED)));
    }

    protected void rejectCommands(Collection<? extends RedisCommand<?, ?, ?>> redisCommands) {
        for (RedisCommand<?, ?, ?> command : redisCommands) {
            command.completeExceptionally(new RedisException(String.format("Command %s not allowed while subscribed. Allowed commands are: %s", command.getType().toString(), ALLOWED_COMMANDS_SUBSCRIBED)));
        }
    }

    protected boolean containsViolatingCommands(Collection<? extends RedisCommand<?, ?, ?>> redisCommands) {
        for (RedisCommand<?, ?, ?> redisCommand : redisCommands) {
            if (this.isAllowed(redisCommand)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowed(RedisCommand<?, ?, ?> command) {
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2 = protocolVersion = this.connectionState != null ? this.connectionState.getNegotiatedProtocolVersion() : null;
        if (protocolVersion == null) {
            protocolVersion = this.getProtocolVersion();
        }
        return protocolVersion == ProtocolVersion.RESP3 || ALLOWED_COMMANDS_SUBSCRIBED.contains(command.getType().toString());
    }

    public boolean isSubscribed() {
        return this.subscribeWritten && (this.hasChannelSubscriptions() || this.hasPatternSubscriptions());
    }

    void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    void notifyMessage(PubSubMessage<K, V> message) {
        if (message.type() == null || message.pattern() == null && message.channel() == null && message.body() == null) {
            return;
        }
        this.updateInternalState(message);
        try {
            this.notifyListeners(message);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred in RedisPubSubListener callback", e);
        }
    }

    protected void notifyListeners(PubSubMessage<K, V> message) {
        block11: for (RedisPubSubListener<K, V> listener : this.listeners) {
            switch (message.type()) {
                case message: {
                    listener.message(message.channel(), message.body());
                    continue block11;
                }
                case pmessage: {
                    listener.message(message.pattern(), message.channel(), message.body());
                    continue block11;
                }
                case psubscribe: {
                    listener.psubscribed(message.pattern(), message.count());
                    continue block11;
                }
                case punsubscribe: {
                    listener.punsubscribed(message.pattern(), message.count());
                    continue block11;
                }
                case subscribe: {
                    listener.subscribed(message.channel(), message.count());
                    continue block11;
                }
                case unsubscribe: {
                    listener.unsubscribed(message.channel(), message.count());
                    continue block11;
                }
                case smessage: {
                    listener.smessage(message.channel(), message.body());
                    continue block11;
                }
                case ssubscribe: {
                    listener.ssubscribed(message.channel(), message.count());
                    continue block11;
                }
                case sunsubscribe: {
                    listener.sunsubscribed(message.channel(), message.count());
                    continue block11;
                }
            }
            throw new UnsupportedOperationException("Operation " + (Object)((Object)message.type()) + " not supported");
        }
    }

    private void updateInternalState(PubSubMessage<K, V> message) {
        switch (message.type()) {
            case psubscribe: {
                this.patterns.add(new Wrapper<K>(message.pattern()));
                break;
            }
            case punsubscribe: {
                this.patterns.remove(new Wrapper<K>(message.pattern()));
                break;
            }
            case subscribe: {
                this.channels.add(new Wrapper<K>(message.channel()));
                break;
            }
            case unsubscribe: {
                this.channels.remove(new Wrapper<K>(message.channel()));
                break;
            }
            case ssubscribe: {
                this.shardChannels.add(new Wrapper<K>(message.channel()));
                break;
            }
            case sunsubscribe: {
                this.shardChannels.remove(new Wrapper<K>(message.channel()));
                break;
            }
        }
    }

    private Set<K> unwrap(Set<Wrapper<K>> wrapped) {
        LinkedHashSet result = new LinkedHashSet(wrapped.size());
        for (Wrapper<K> channel : wrapped) {
            result.add(channel.name);
        }
        return result;
    }

    static {
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.SUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.PSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.UNSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.PUNSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.SSUBSCRIBE.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.QUIT.name());
        ALLOWED_COMMANDS_SUBSCRIBED.add(CommandType.PING.name());
        SUBSCRIBE_COMMANDS = new HashSet<String>(2, 1.0f);
        SUBSCRIBE_COMMANDS.add(CommandType.SUBSCRIBE.name());
        SUBSCRIBE_COMMANDS.add(CommandType.PSUBSCRIBE.name());
        SUBSCRIBE_COMMANDS.add(CommandType.SSUBSCRIBE.name());
    }

    static class Wrapper<K> {
        protected final K name;

        public Wrapper(K name) {
            this.name = name;
        }

        public int hashCode() {
            if (this.name instanceof byte[]) {
                return Arrays.hashCode((byte[])this.name);
            }
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Wrapper)) {
                return false;
            }
            Wrapper that = (Wrapper)obj;
            if (this.name instanceof byte[] && that.name instanceof byte[]) {
                return Arrays.equals((byte[])this.name, (byte[])that.name);
            }
            return this.name.equals(that.name);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [name=").append(this.name);
            sb.append(']');
            return sb.toString();
        }
    }
}

