/*
 * Decompiled with CFR 0.152.
 */
package com.infernalsuite.asp.loaders.mongo;

import com.infernalsuite.asp.api.exceptions.UnknownWorldException;
import com.infernalsuite.asp.api.loaders.UpdatableLoader;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoLoader
extends UpdatableLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoLoader.class);
    private final MongoClient client;
    private final String database;
    private final String collection;

    public MongoLoader(String database, String collection, @Nullable String username, @Nullable String password, @Nullable String authSource, @Nullable String host, @Nullable Integer port, @Nullable String uri) throws MongoException {
        this.database = database;
        this.collection = collection;
        String authParams = username != null && password != null ? username + ":" + password + "@" : "";
        Object parsedAuthSource = authSource != null ? "/?authSource=" + authSource : "";
        Object parsedUri = uri != null && !uri.isBlank() ? uri : "mongodb://" + authParams + host + ":" + port + (String)parsedAuthSource;
        this.client = MongoClients.create((String)parsedUri);
        this.init();
    }

    public MongoLoader(MongoClient client, String database, String collection) {
        this.database = database;
        this.collection = collection;
        this.client = client;
        this.init();
    }

    private void init() {
        MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
        MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
        mongoCollection.createIndex(Indexes.ascending("name"), new IndexOptions().unique(true));
    }

    public void update() {
        block12: {
            MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
            for (String collectionName : mongoDatabase.listCollectionNames()) {
                if (!collectionName.equals(this.collection + "_files.files") && !collectionName.equals(this.collection + "_files.chunks")) continue;
                LOGGER.info("Updating MongoDB database...");
                mongoDatabase.getCollection(this.collection + "_files.files").renameCollection(new MongoNamespace(this.database, this.collection + ".files"));
                mongoDatabase.getCollection(this.collection + "_files.chunks").renameCollection(new MongoNamespace(this.database, this.collection + ".chunks"));
                LOGGER.info("MongoDB database updated!");
                break;
            }
            MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
            try (MongoCursor documents = mongoCollection.find(Filters.or(Filters.eq("locked", true), Filters.eq("locked", false))).cursor();){
                if (!documents.hasNext()) break block12;
                LOGGER.warn("Your SWM MongoDB database is outdated. The update process will start in 10 seconds.");
                LOGGER.warn("Note that this update will make your database incompatible with older SWM versions.");
                LOGGER.warn("Make sure no other servers with older SWM versions are using this database.");
                LOGGER.warn("Shut down the server to prevent your database from being updated.");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOGGER.info("Update process aborted.");
                    if (documents != null) {
                        documents.close();
                    }
                    return;
                }
                while (documents.hasNext()) {
                    String name = ((Document)documents.next()).getString("name");
                    mongoCollection.updateOne(Filters.eq("name", name), Updates.set("locked", 0L));
                }
            }
        }
    }

    public byte[] readWorld(String worldName) throws UnknownWorldException, IOException {
        try {
            MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
            MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
            Document worldDoc = (Document)mongoCollection.find(Filters.eq("name", worldName)).first();
            if (worldDoc == null) {
                throw new UnknownWorldException(worldName);
            }
            GridFSBucket bucket = GridFSBuckets.create(mongoDatabase, this.collection);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bucket.downloadToStream(worldName, (OutputStream)stream);
            return stream.toByteArray();
        }
        catch (MongoException ex) {
            throw new IOException(ex);
        }
    }

    public boolean worldExists(String worldName) throws IOException {
        try {
            MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
            MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
            Document worldDoc = (Document)mongoCollection.find(Filters.eq("name", worldName)).first();
            return worldDoc != null;
        }
        catch (MongoException ex) {
            throw new IOException(ex);
        }
    }

    public List<String> listWorlds() throws IOException {
        ArrayList<String> worldList = new ArrayList<String>();
        try {
            MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
            MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
            try (MongoCursor documents = mongoCollection.find().cursor();){
                while (documents.hasNext()) {
                    worldList.add(((Document)documents.next()).getString("name"));
                }
            }
        }
        catch (MongoException ex) {
            throw new IOException(ex);
        }
        return worldList;
    }

    public void saveWorld(String worldName, byte[] serializedWorld) throws IOException {
        try {
            MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
            GridFSBucket bucket = GridFSBuckets.create(mongoDatabase, this.collection);
            GridFSFile oldFile = (GridFSFile)bucket.find(Filters.eq("filename", worldName)).first();
            bucket.uploadFromStream(worldName, new ByteArrayInputStream(serializedWorld));
            if (oldFile != null) {
                bucket.delete(oldFile.getObjectId());
            }
            MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
            Bson query = Filters.eq("name", worldName);
            mongoCollection.updateOne(query, (Bson)new Document().append("$set", query), new UpdateOptions().upsert(true));
        }
        catch (MongoException ex) {
            throw new IOException(ex);
        }
    }

    public void deleteWorld(String worldName) throws IOException, UnknownWorldException {
        try {
            MongoDatabase mongoDatabase = this.client.getDatabase(this.database);
            GridFSBucket bucket = GridFSBuckets.create(mongoDatabase, this.collection);
            GridFSFile file = (GridFSFile)bucket.find(Filters.eq("filename", worldName)).first();
            if (file == null) {
                throw new UnknownWorldException(worldName);
            }
            bucket.delete(file.getObjectId());
            for (GridFSFile backupFile : bucket.find(Filters.eq("filename", worldName + "_backup"))) {
                bucket.delete(backupFile.getObjectId());
            }
            MongoCollection<Document> mongoCollection = mongoDatabase.getCollection(this.collection);
            mongoCollection.deleteOne(Filters.eq("name", worldName));
        }
        catch (MongoException ex) {
            throw new IOException(ex);
        }
    }
}

