/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class AsyncOperations<TDocument> {
    private final Operations<TDocument> operations;
    private final TimeoutSettings timeoutSettings;

    public AsyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, TimeoutSettings timeoutSettings) {
        WriteConcern writeConcernToUse = writeConcern;
        if (timeoutSettings.getTimeoutMS() != null) {
            writeConcernToUse = Assertions.assertNotNull(WriteConcernHelper.cloneWithoutTimeout(writeConcern));
        }
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcernToUse, retryWrites, retryReads);
        this.timeoutSettings = timeoutSettings;
    }

    public MongoNamespace getNamespace() {
        return Assertions.assertNotNull(this.operations.getNamespace());
    }

    public Class<TDocument> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    public CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    public ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    public WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public boolean isRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean isRetryReads() {
        return this.operations.isRetryReads();
    }

    public TimeoutSettings createTimeoutSettings(long maxTimeMS) {
        return this.timeoutSettings.withMaxTimeMS(maxTimeMS);
    }

    public TimeoutSettings createTimeoutSettings(long maxTimeMS, long maxAwaitTimeMS) {
        return this.timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(maxTimeMS, maxAwaitTimeMS);
    }

    public TimeoutSettings createTimeoutSettings(CountOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(EstimatedDocumentCountOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOptions options) {
        return this.timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS), options.getMaxAwaitTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndDeleteOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndReplaceOptions options) {
        return this.createTimeoutSettings(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndUpdateOptions options) {
        return this.timeoutSettings.withMaxTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public AsyncReadOperation<Long> countDocuments(Bson filter, CountOptions options) {
        return this.operations.countDocuments(filter, options);
    }

    public AsyncReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.operations.estimatedDocumentCount(options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> findFirst(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.findFirst(filter, resultClass, options);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> find(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(filter, resultClass, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(findNamespace, filter, resultClass, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> distinct(String fieldName, Bson filter, Class<TResult> resultClass, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter, resultClass, collation, comment);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, @Nullable TimeoutMode timeoutMode, @Nullable Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, timeoutMode, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public AsyncReadOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, @Nullable TimeoutMode timeoutMode, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, timeoutMode, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public AsyncWriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter, int limit, boolean jsMode, Bson scope, Bson sort, boolean verbose, MapReduceAction action, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter, limit, jsMode, scope, sort, verbose, action, bypassDocumentValidation, collation);
    }

    public <TResult> AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter, int limit, boolean jsMode, Bson scope, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter, limit, jsMode, scope, sort, verbose, collation);
    }

    public AsyncWriteOperation<TDocument> findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.operations.findOneAndDelete(filter, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.operations.findOneAndReplace(filter, replacement, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public AsyncWriteOperation<BulkWriteResult> insertOne(TDocument document, InsertOneOptions options) {
        return this.operations.insertOne(document, options);
    }

    public AsyncWriteOperation<BulkWriteResult> replaceOne(Bson filter, TDocument replacement, ReplaceOptions options) {
        return this.operations.replaceOne(filter, replacement, options);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteOne(Bson filter, DeleteOptions options) {
        return this.operations.deleteOne(filter, options);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteMany(Bson filter, DeleteOptions options) {
        return this.operations.deleteMany(filter, options);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.operations.insertMany(documents, options);
    }

    public AsyncWriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.operations.bulkWrite(requests, options);
    }

    public <TResult> AsyncReadOperation<TResult> commandRead(Bson command, Class<TResult> resultClass) {
        return this.operations.commandRead(command, resultClass);
    }

    public AsyncWriteOperation<Void> dropDatabase() {
        return this.operations.dropDatabase();
    }

    public AsyncWriteOperation<Void> createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.createCollection(collectionName, createCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.operations.renameCollection(newCollectionNamespace, options);
    }

    public AsyncWriteOperation<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return this.operations.createView(viewName, viewOn, pipeline, createViewOptions);
    }

    public AsyncWriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.operations.createIndexes(indexes, options);
    }

    public AsyncWriteOperation<Void> createSearchIndexes(List<SearchIndexModel> indexes) {
        return this.operations.createSearchIndexes(indexes);
    }

    public AsyncWriteOperation<Void> updateSearchIndex(String indexName, Bson definition) {
        return this.operations.updateSearchIndex(indexName, definition);
    }

    public AsyncWriteOperation<Void> dropSearchIndex(String indexName) {
        return this.operations.dropSearchIndex(indexName);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> listSearchIndexes(Class<TResult> resultClass, @Nullable String indexName, @Nullable Integer batchSize, @Nullable Collation collation, @Nullable BsonValue comment, @Nullable Boolean allowDiskUse) {
        return this.operations.listSearchIndexes(resultClass, indexName, batchSize, collation, comment, allowDiskUse);
    }

    public AsyncWriteOperation<Void> dropIndex(String indexName, DropIndexOptions options) {
        return this.operations.dropIndex(indexName, options);
    }

    public AsyncWriteOperation<Void> dropIndex(Bson keys2, DropIndexOptions options) {
        return this.operations.dropIndex(keys2, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter, boolean collectionNamesOnly, boolean authorizedCollections, @Nullable Integer batchSize, BsonValue comment, @Nullable TimeoutMode timeoutMode) {
        return this.operations.listCollections(databaseName, resultClass, filter, collectionNamesOnly, authorizedCollections, batchSize, comment, timeoutMode);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter, Boolean nameOnly, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter, nameOnly, authorizedDatabases, comment);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listIndexes(Class<TResult> resultClass, @Nullable Integer batchSize, BsonValue comment, @Nullable TimeoutMode timeoutMode) {
        return this.operations.listIndexes(resultClass, batchSize, comment, timeoutMode);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> pipeline, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, Integer batchSize, Collation collation, BsonValue comment, BsonDocument resumeToken, BsonTimestamp startAtOperationTime, BsonDocument startAfter, boolean showExpandedEvents) {
        return this.operations.changeStream(fullDocument, fullDocumentBeforeChange, pipeline, decoder, changeStreamLevel, batchSize, collation, comment, resumeToken, startAtOperationTime, startAfter, showExpandedEvents);
    }
}

