/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SearchIndexType;
import com.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.mongodb.internal.operation.SearchIndexRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

final class CreateSearchIndexesOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "createSearchIndexes";
    private final List<SearchIndexRequest> indexRequests;

    CreateSearchIndexesOperation(MongoNamespace namespace, List<SearchIndexRequest> indexRequests) {
        super(namespace);
        this.indexRequests = Assertions.assertNotNull(indexRequests);
    }

    private static BsonArray convert(List<SearchIndexRequest> requests) {
        return requests.stream().map(CreateSearchIndexesOperation::convert).collect(Collectors.toCollection(BsonArray::new));
    }

    private static BsonDocument convert(SearchIndexRequest request) {
        SearchIndexType searchIndexType;
        BsonDocument bsonIndexRequest = new BsonDocument();
        String searchIndexName = request.getIndexName();
        if (searchIndexName != null) {
            bsonIndexRequest.append("name", new BsonString(searchIndexName));
        }
        if ((searchIndexType = request.getSearchIndexType()) != null) {
            bsonIndexRequest.append("type", searchIndexType.toBsonValue());
        }
        bsonIndexRequest.append("definition", request.getDefinition());
        return bsonIndexRequest;
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(COMMAND_NAME, new BsonString(this.getNamespace().getCollectionName())).append("indexes", CreateSearchIndexesOperation.convert(this.indexRequests));
    }
}

