/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingSyncSupplier;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class SyncOperationHelper {
    private static final BsonDocumentCodec BSON_DOCUMENT_CODEC = new BsonDocumentCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withReadConnectionSource(ReadBinding binding, CallableWithSource<T> callable) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = callable.call(source);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(WriteBinding binding, CallableWithConnection<T> callable) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t = SyncOperationHelper.withConnectionSource(source, callable);
            return t;
        }
        finally {
            source.release();
        }
    }

    static <R> R withSourceAndConnection(Supplier<ConnectionSource> sourceSupplier, boolean wrapConnectionSourceException, BiFunction<ConnectionSource, Connection, R> function) throws OperationHelper.ResourceSupplierInternalException {
        return (R)SyncOperationHelper.withSuppliedResource(sourceSupplier, wrapConnectionSourceException, source -> SyncOperationHelper.withSuppliedResource(source::getConnection, wrapConnectionSourceException, connection -> function.apply((ConnectionSource)source, (Connection)connection)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R, T extends ReferenceCounted> R withSuppliedResource(Supplier<T> resourceSupplier, boolean wrapSupplierException, java.util.function.Function<T, R> function) throws OperationHelper.ResourceSupplierInternalException {
        ReferenceCounted resource = null;
        try {
            try {
                resource = (ReferenceCounted)resourceSupplier.get();
            }
            catch (Exception supplierException) {
                if (wrapSupplierException) {
                    throw new OperationHelper.ResourceSupplierInternalException(supplierException);
                }
                throw supplierException;
            }
            R r = function.apply(resource);
            return r;
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withConnectionSource(ConnectionSource source, CallableWithConnection<T> callable) {
        Connection connection = source.getConnection();
        try {
            T t = callable.call(connection);
            return t;
        }
        finally {
            connection.release();
        }
    }

    static <D, T> T executeRetryableRead(ReadBinding binding, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        return SyncOperationHelper.executeRetryableRead(binding, binding::getReadConnectionSource, database, commandCreator, decoder, transformer, retryReads);
    }

    static <D, T> T executeRetryableRead(ReadBinding binding, Supplier<ConnectionSource> readConnectionSourceSupplier, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        RetryState retryState = CommandOperationHelper.initialRetryState(retryReads, binding.getOperationContext().getTimeoutContext());
        Supplier<Object> read = SyncOperationHelper.decorateReadWithRetries(retryState, binding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(readConnectionSourceSupplier, false, (source, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getOperationContext()));
            return SyncOperationHelper.createReadCommandAndExecute(retryState, binding.getOperationContext(), source, database, commandCreator, decoder, transformer, connection);
        }));
        return (T)read.get();
    }

    static <T> T executeCommand(WriteBinding binding, String database, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformer<BsonDocument, T> transformer) {
        return (T)SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, false, (source, connection) -> transformer.apply(Assertions.assertNotNull(connection.command(database, commandCreator.create(binding.getOperationContext(), source.getServerDescription(), connection.getDescription()), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), BSON_DOCUMENT_CODEC, binding.getOperationContext())), (Connection)connection));
    }

    static <D, T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandWriteTransformer<D, T> transformer) {
        return (T)SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, false, (source, connection) -> transformer.apply((Object)Assertions.assertNotNull(connection.command(database, command, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), decoder, binding.getOperationContext())), (Connection)connection));
    }

    @Nullable
    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Connection connection, CommandWriteTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return transformer.apply(Assertions.assertNotNull(connection.command(database, command, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), BSON_DOCUMENT_CODEC, binding.getOperationContext())), connection);
    }

    static <T, R> R executeRetryableWrite(WriteBinding binding, String database, @Nullable ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformer<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true, binding.getOperationContext().getTimeoutContext());
        Supplier<Object> retryingWrite = SyncOperationHelper.decorateWriteWithRetries(retryState, binding.getOperationContext(), () -> {
            boolean firstAttempt = retryState.isFirstAttempt();
            SessionContext sessionContext = binding.getOperationContext().getSessionContext();
            if (!firstAttempt && sessionContext.hasActiveTransaction()) {
                sessionContext.clearTransactionContext();
            }
            return SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, true, (source, connection) -> {
                int maxWireVersion = connection.getDescription().getMaxWireVersion();
                try {
                    retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryWrite(connection.getDescription(), sessionContext));
                    BsonDocument command = retryState.attachment(AttachmentKeys.command()).map(previousAttemptCommand -> {
                        Assertions.assertFalse(firstAttempt);
                        return (BsonDocument)retryCommandModifier.apply((BsonDocument)previousAttemptCommand);
                    }).orElseGet(() -> commandCreator.create(binding.getOperationContext(), source.getServerDescription(), connection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), maxWireVersion, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(command), true).attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, false).attach(AttachmentKeys.command(), command, false);
                    return transformer.apply(Assertions.assertNotNull(connection.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding.getOperationContext())), (Connection)connection);
                }
                catch (MongoException e) {
                    if (!firstAttempt) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(e, maxWireVersion);
                    }
                    throw e;
                }
            });
        });
        try {
            return (R)retryingWrite.get();
        }
        catch (MongoException e) {
            throw CommandOperationHelper.transformWriteException(e);
        }
    }

    @Nullable
    static <D, T> T createReadCommandAndExecute(RetryState retryState, OperationContext operationContext, ConnectionSource source, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, Connection connection) {
        BsonDocument command = commandCreator.create(operationContext, source.getServerDescription(), connection.getDescription());
        retryState.attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, false);
        return transformer.apply(Assertions.assertNotNull(connection.command(database, command, NoOpFieldNameValidator.INSTANCE, source.getReadPreference(), decoder, operationContext)), source, connection);
    }

    static <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> writeFunction) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), CommandOperationHelper::shouldAttemptToRetryWrite, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return writeFunction.get();
        });
    }

    static <R> Supplier<R> decorateReadWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> readFunction) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper.onRetryableReadAttemptFailure(operationContext), CommandOperationHelper::shouldAttemptToRetryRead, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return readFunction.get();
        });
    }

    static CommandWriteTransformer<BsonDocument, Void> writeConcernErrorTransformer(TimeoutContext timeoutContext) {
        return (result, connection) -> {
            Assertions.assertNotNull(result);
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), timeoutContext);
            return null;
        };
    }

    static <T> CommandReadTransformer<BsonDocument, BatchCursor<T>> singleBatchCursorTransformer(String fieldName) {
        return (result, source, connection) -> new SingleBatchCursor(BsonDocumentWrapperHelper.toList(result, fieldName), 0, connection.getDescription().getServerAddress());
    }

    static <T> BatchCursor<T> cursorDocumentToBatchCursor(TimeoutMode timeoutMode, BsonDocument cursorDocument, int batchSize, Decoder<T> decoder, BsonValue comment, ConnectionSource source, Connection connection) {
        return new CommandBatchCursor<T>(timeoutMode, cursorDocument, batchSize, 0L, decoder, comment, source, connection);
    }

    private SyncOperationHelper() {
    }

    static interface CallableWithSource<T> {
        public T call(ConnectionSource var1);
    }

    static interface CallableWithConnection<T> {
        public T call(Connection var1);
    }

    static interface CommandReadTransformer<T, R> {
        @Nullable
        public R apply(T var1, ConnectionSource var2, Connection var3);
    }

    static interface CommandWriteTransformer<T, R> {
        @Nullable
        public R apply(T var1, Connection var2);
    }
}

