/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.config;

import dev.danielmillar.slimelink.SlimeLink;
import dev.danielmillar.slimelink.config.DatasourcesConfig;
import dev.danielmillar.slimelink.config.WorldsConfig;
import io.leangen.geantyref.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/danielmillar/slimelink/config/ConfigManager;", "", "<init>", "()V", "pluginDir", "Ljava/io/File;", "worldsFile", "sourcesFile", "worldLoader", "Lorg/spongepowered/configurate/yaml/YamlConfigurationLoader;", "datasourcesLoader", "worldConfig", "Ldev/danielmillar/slimelink/config/WorldsConfig;", "datasourcesConfig", "Ldev/danielmillar/slimelink/config/DatasourcesConfig;", "initialize", "", "copyDefaultConfigs", "saveWorldConfig", "saveDatasourcesConfig", "getWorldConfig", "getDatasourcesConfig", "SlimeLink"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\ndev/danielmillar/slimelink/config/ConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE;
    @NotNull
    private static final File pluginDir;
    @NotNull
    private static final File worldsFile;
    @NotNull
    private static final File sourcesFile;
    private static YamlConfigurationLoader worldLoader;
    private static YamlConfigurationLoader datasourcesLoader;
    private static WorldsConfig worldConfig;
    private static DatasourcesConfig datasourcesConfig;

    private ConfigManager() {
    }

    public final void initialize() throws IOException {
        DatasourcesConfig datasourcesConfig;
        WorldsConfig worldsConfig;
        this.copyDefaultConfigs();
        YamlConfigurationLoader yamlConfigurationLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(worldsFile)).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).build();
        Intrinsics.checkNotNullExpressionValue(yamlConfigurationLoader, "build(...)");
        worldLoader = yamlConfigurationLoader;
        YamlConfigurationLoader yamlConfigurationLoader2 = worldLoader;
        if (yamlConfigurationLoader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldLoader");
            yamlConfigurationLoader2 = null;
        }
        if ((worldsConfig = ((CommentedConfigurationNode)yamlConfigurationLoader2.load()).get(TypeToken.get(WorldsConfig.class))) == null) {
            worldsConfig = new WorldsConfig(null, 1, null);
        }
        worldConfig = worldsConfig;
        YamlConfigurationLoader yamlConfigurationLoader3 = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(sourcesFile)).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESERVE)).build();
        Intrinsics.checkNotNullExpressionValue(yamlConfigurationLoader3, "build(...)");
        datasourcesLoader = yamlConfigurationLoader3;
        YamlConfigurationLoader yamlConfigurationLoader4 = datasourcesLoader;
        if (yamlConfigurationLoader4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("datasourcesLoader");
            yamlConfigurationLoader4 = null;
        }
        if ((datasourcesConfig = ((CommentedConfigurationNode)yamlConfigurationLoader4.load()).get(TypeToken.get(DatasourcesConfig.class))) == null) {
            datasourcesConfig = new DatasourcesConfig(null, null, null, 7, null);
        }
        ConfigManager.datasourcesConfig = datasourcesConfig;
        this.saveWorldConfig();
        this.saveDatasourcesConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyDefaultConfigs() {
        block13: {
            Object input;
            Throwable throwable;
            Closeable closeable;
            if (!worldsFile.exists()) {
                InputStream inputStream = SlimeLink.Companion.getInstance().getResource("worlds.yml");
                if (inputStream != null) {
                    closeable = inputStream;
                    throwable = null;
                    try {
                        input = (InputStream)closeable;
                        boolean bl = false;
                        input = Files.copy((InputStream)input, worldsFile.toPath(), new CopyOption[0]);
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
            }
            if (sourcesFile.exists()) break block13;
            InputStream inputStream = SlimeLink.Companion.getInstance().getResource("sources.yml");
            if (inputStream != null) {
                closeable = inputStream;
                throwable = null;
                try {
                    input = (InputStream)closeable;
                    boolean bl = false;
                    Long l = Files.copy((InputStream)input, sourcesFile.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        }
    }

    public final void saveWorldConfig() throws IOException {
        YamlConfigurationLoader yamlConfigurationLoader;
        YamlConfigurationLoader yamlConfigurationLoader2 = worldLoader;
        if (yamlConfigurationLoader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldLoader");
            yamlConfigurationLoader2 = null;
        }
        if ((yamlConfigurationLoader = worldLoader) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldLoader");
            yamlConfigurationLoader = null;
        }
        CommentedConfigurationNode commentedConfigurationNode = (CommentedConfigurationNode)yamlConfigurationLoader.createNode();
        TypeToken<WorldsConfig> typeToken = TypeToken.get(WorldsConfig.class);
        WorldsConfig worldsConfig = worldConfig;
        if (worldsConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldConfig");
            worldsConfig = null;
        }
        yamlConfigurationLoader2.save(commentedConfigurationNode.set(typeToken, (Object)worldsConfig));
    }

    public final void saveDatasourcesConfig() throws IOException {
        YamlConfigurationLoader yamlConfigurationLoader;
        YamlConfigurationLoader yamlConfigurationLoader2 = datasourcesLoader;
        if (yamlConfigurationLoader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("datasourcesLoader");
            yamlConfigurationLoader2 = null;
        }
        if ((yamlConfigurationLoader = datasourcesLoader) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("datasourcesLoader");
            yamlConfigurationLoader = null;
        }
        CommentedConfigurationNode commentedConfigurationNode = (CommentedConfigurationNode)yamlConfigurationLoader.createNode();
        TypeToken<DatasourcesConfig> typeToken = TypeToken.get(DatasourcesConfig.class);
        DatasourcesConfig datasourcesConfig = ConfigManager.datasourcesConfig;
        if (datasourcesConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("datasourcesConfig");
            datasourcesConfig = null;
        }
        yamlConfigurationLoader2.save(commentedConfigurationNode.set(typeToken, (Object)datasourcesConfig));
    }

    @NotNull
    public final WorldsConfig getWorldConfig() {
        WorldsConfig worldsConfig = worldConfig;
        if (worldsConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldConfig");
            worldsConfig = null;
        }
        return worldsConfig;
    }

    @NotNull
    public final DatasourcesConfig getDatasourcesConfig() {
        DatasourcesConfig datasourcesConfig = ConfigManager.datasourcesConfig;
        if (datasourcesConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("datasourcesConfig");
            datasourcesConfig = null;
        }
        return datasourcesConfig;
    }

    static {
        File file;
        INSTANCE = new ConfigManager();
        File $this$pluginDir_u24lambda_u240 = file = new File("plugins", "SlimeLink");
        boolean bl = false;
        $this$pluginDir_u24lambda_u240.mkdirs();
        pluginDir = file;
        worldsFile = new File(pluginDir, "worlds.yml");
        sourcesFile = new File(pluginDir, "sources.yml");
    }
}

