/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.config;

import dev.danielmillar.slimelink.config.ConfigManager;
import dev.danielmillar.slimelink.config.WorldData;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\rJ\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u001c\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/danielmillar/slimelink/config/WorldsConfig;", "", "worlds", "", "", "Ldev/danielmillar/slimelink/config/WorldData;", "<init>", "(Ljava/util/Map;)V", "getWorlds", "", "getWorld", "worldName", "setWorld", "", "worldData", "removeWorld", "hasWorld", "", "save", "component1", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "SlimeLink"})
public final class WorldsConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Setting(value="worlds")
    @NotNull
    private final Map<String, WorldData> worlds;
    private static final Logger logger = LoggerFactory.getLogger(WorldsConfig.class);

    public WorldsConfig(@NotNull Map<String, WorldData> worlds) {
        Intrinsics.checkNotNullParameter(worlds, "worlds");
        this.worlds = worlds;
    }

    public /* synthetic */ WorldsConfig(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, WorldData> getWorlds() {
        return MapsKt.toMap(this.worlds);
    }

    @Nullable
    public final WorldData getWorld(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        return this.worlds.get(worldName);
    }

    public final void setWorld(@NotNull String worldName, @NotNull WorldData worldData) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        Intrinsics.checkNotNullParameter(worldData, "worldData");
        this.worlds.put(worldName, worldData);
    }

    @Nullable
    public final WorldData removeWorld(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        return this.worlds.remove(worldName);
    }

    public final boolean hasWorld(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter(worldName, "worldName");
        return this.worlds.containsKey(worldName);
    }

    public final void save() {
        try {
            ConfigManager.INSTANCE.saveWorldConfig();
        }
        catch (IOException ex) {
            logger.error("Failed to save worlds config", ex);
        }
    }

    private final Map<String, WorldData> component1() {
        return this.worlds;
    }

    @NotNull
    public final WorldsConfig copy(@NotNull Map<String, WorldData> worlds) {
        Intrinsics.checkNotNullParameter(worlds, "worlds");
        return new WorldsConfig(worlds);
    }

    public static /* synthetic */ WorldsConfig copy$default(WorldsConfig worldsConfig, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = worldsConfig.worlds;
        }
        return worldsConfig.copy(map);
    }

    @NotNull
    public String toString() {
        return "WorldsConfig(worlds=" + this.worlds + ")";
    }

    public int hashCode() {
        return ((Object)this.worlds).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorldsConfig)) {
            return false;
        }
        WorldsConfig worldsConfig = (WorldsConfig)other;
        return Intrinsics.areEqual(this.worlds, worldsConfig.worlds);
    }

    public WorldsConfig() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/danielmillar/slimelink/config/WorldsConfig$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

