/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.infernalsuite.asp.api.loaders.SlimeLoader;
import com.infernalsuite.asp.api.world.properties.SlimePropertyMap;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import java.io.IOException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Create Slime World")
@Description(value={"This effect allows you to create a new slime world with a name, SlimePropertyMap, read only and datasource.."})
@Examples(value={"create slimeworld named \"MyWorld\" with props {globalProps} with datasource file", "new slime world named \"MyWorld\" with props {globalProps} with file", "create slimeworld named \"ReadOnlyWorld\" with props {globalProps} as ReadOnly with datasource mysql", "new slime world named \"AnotherWorld\" with props {globalProps} as ReadOnly with mysql", "create slimeworld named \"MyWorld\" with props {globalProps} with datasource mongodb", "new slime world named \"MyWorld\" with props {globalProps} with mongodb"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J?\u0010\u0011\u001a\u00020\f2\u0014\u0010\u0012\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffCreateSlimeWorld;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "worldName", "Lch/njol/skript/lang/Expression;", "", "slimeProperties", "Lcom/infernalsuite/asp/api/world/properties/SlimePropertyMap;", "loaderType", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "isReadOnly", "", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "execute", "", "Companion", "SlimeLink"})
public final class EffCreateSlimeWorld
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<String> worldName;
    private Expression<SlimePropertyMap> slimeProperties;
    private Expression<SlimeLoaderTypeEnum> loaderType;
    private boolean isReadOnly;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        String string = expression.toString(event, debug);
        Expression<SlimePropertyMap> expression2 = this.slimeProperties;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression2 = null;
        }
        String string2 = expression2.toString(event, debug);
        String string3 = this.isReadOnly ? "as readOnly" : "";
        Expression<SlimeLoaderTypeEnum> expression3 = this.loaderType;
        if (expression3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression3 = null;
        }
        return "Create slime world " + string + " with properties " + string2 + " " + string3 + " with datasource " + expression3.toString(event, debug);
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.worldName = expression;
        Expression<?> expression2 = expressions[1];
        Intrinsics.checkNotNull(expression2, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<com.infernalsuite.asp.api.world.properties.SlimePropertyMap>");
        this.slimeProperties = expression2;
        Expression<?> expression3 = expressions[2];
        Intrinsics.checkNotNull(expression3, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum>");
        this.loaderType = expression3;
        SkriptParser.ParseResult parseResult2 = parseResult;
        this.isReadOnly = parseResult2 != null ? parseResult2.hasTag("readonly") : false;
        return true;
    }

    protected void execute(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<String> expression = this.worldName;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("worldName");
            expression = null;
        }
        String string = (String)expression.getSingle(event);
        if (string == null) {
            return;
        }
        String worldNameValue = string;
        Expression<SlimePropertyMap> expression2 = this.slimeProperties;
        if (expression2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("slimeProperties");
            expression2 = null;
        }
        SlimePropertyMap slimePropertyMap = (SlimePropertyMap)expression2.getSingle(event);
        if (slimePropertyMap == null) {
            return;
        }
        SlimePropertyMap properties = slimePropertyMap;
        Expression<SlimeLoaderTypeEnum> expression3 = this.loaderType;
        if (expression3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression3 = null;
        }
        SlimeLoaderTypeEnum slimeLoaderTypeEnum = (SlimeLoaderTypeEnum)((Object)expression3.getSingle(event));
        if (slimeLoaderTypeEnum == null) {
            return;
        }
        SlimeLoaderTypeEnum loaderTypeValue = slimeLoaderTypeEnum;
        try {
            SlimeWorldUtils.INSTANCE.validateWorldName(worldNameValue);
            SlimeWorldUtils.requireWorldNotExists$default(SlimeWorldUtils.INSTANCE, worldNameValue, null, 2, null);
            SlimeWorldUtils.requireWorldDataNotExists$default(SlimeWorldUtils.INSTANCE, worldNameValue, null, 2, null);
            SlimeLoader loader = SlimeWorldUtils.requireLoader$default(SlimeWorldUtils.INSTANCE, loaderTypeValue, null, 2, null);
            String string2 = loaderTypeValue.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            SlimeWorldUtils.INSTANCE.createAndLoadWorldAsync(worldNameValue, properties, loader, string2, this.isReadOnly);
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
        }
        catch (IOException io) {
            Skript.error((String)("I/O error while creating world '" + worldNameValue + "': " + io.getMessage()));
            io.printStackTrace();
        }
    }

    static {
        String[] stringArray = new String[]{"(create|new) (slimeworld|slime world) named %string% with props %slimepropertymap% [readonly:as ReadOnly] with [datasource|data source] %slimeloader%"};
        Skript.registerEffect(EffCreateSlimeWorld.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffCreateSlimeWorld$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

