/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum;
import dev.danielmillar.slimelink.slime.SlimeManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Initialize Loader")
@Description(value={"**IMPORTANT**", "This effect initializes the Slime loader with the specified loader type.", "This must be ran at least once for anything to work."})
@Since(value={"1.0.0"})
@Examples(value={"initialize slime loader with datasource file", "initialize slime loader with datasource mysql", "initialize slime loader with datasource mongodb", "initialize slime loader with file", "initialize slime loader with mysql", "initialize slime loader with mongodb"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J?\u0010\u000f\u001a\u00020\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffInitializeLoader;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "loaderType", "Lch/njol/skript/lang/Expression;", "Ldev/danielmillar/slimelink/slime/SlimeLoaderTypeEnum;", "execute", "", "event", "Lorg/bukkit/event/Event;", "toString", "", "debug", "", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parser", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "Companion", "SlimeLink"})
public final class EffInitializeLoader
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<SlimeLoaderTypeEnum> loaderType;

    protected void execute(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<SlimeLoaderTypeEnum> expression = this.loaderType;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression = null;
        }
        SlimeLoaderTypeEnum slimeLoaderTypeEnum = (SlimeLoaderTypeEnum)((Object)expression.getSingle(event));
        if (slimeLoaderTypeEnum == null) {
            return;
        }
        SlimeLoaderTypeEnum loaderTypeValue = slimeLoaderTypeEnum;
        try {
            boolean success = SlimeManager.INSTANCE.registerLoader(loaderTypeValue);
            if (!success || SlimeManager.INSTANCE.getLoader(loaderTypeValue) == null) {
                String string = loaderTypeValue.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                Skript.error((String)("An error occurred while trying to initialize Slime Loader. Loader datasource: " + string + ". Make sure this datasource is enabled and the credentials are correct, if applicable."));
            }
        }
        catch (Exception ex) {
            Skript.error((String)("Failed to initialize Slime Loader: " + ex.getMessage() + "."));
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<SlimeLoaderTypeEnum> expression = this.loaderType;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("loaderType");
            expression = null;
        }
        String string = expression.toString(event, debug);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return "initialize slime loader with datasource " + string2;
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parser) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<dev.danielmillar.slimelink.slime.SlimeLoaderTypeEnum>");
        this.loaderType = expression;
        return true;
    }

    static {
        String[] stringArray = new String[]{"initialize slime loader with [datasource|data source] %slimeloader%"};
        Skript.registerEffect(EffInitializeLoader.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffInitializeLoader$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

