/*
 * Decompiled with CFR 0.152.
 */
package dev.danielmillar.slimelink.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.danielmillar.slimelink.config.WorldData;
import dev.danielmillar.slimelink.util.SlimeWorldUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Unload Slime World By Object")
@Description(value={"This effect allows you to unload a specific SlimeWorld.", "There is an optional to teleport players out of the world as there must be no players in the world while unloading."})
@Examples(value={"unload slimeworld {world}", "unload slime world {myWorld}", "unload slimeworld {world} and teleport to {spawnLocation}", "unload slime world {myWorld} and teleport to location(0, 64, 0, world(\"world\"))"})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J?\u0010\u0010\u001a\u00020\b2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffUnloadSlimeWorldByObject;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "world", "Lch/njol/skript/lang/Expression;", "Lorg/bukkit/World;", "shouldTeleport", "", "teleportLocation", "Lorg/bukkit/Location;", "toString", "", "event", "Lorg/bukkit/event/Event;", "debug", "init", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "execute", "", "Companion", "SlimeLink"})
@SourceDebugExtension(value={"SMAP\nEffUnloadSlimeWorldByObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffUnloadSlimeWorldByObject.kt\ndev/danielmillar/slimelink/skript/effects/EffUnloadSlimeWorldByObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class EffUnloadSlimeWorldByObject
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Expression<World> world;
    private boolean shouldTeleport;
    @Nullable
    private Expression<Location> teleportLocation;

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        Expression<World> expression;
        Object locationStr;
        block5: {
            Object object;
            block4: {
                object = this.teleportLocation;
                if (object == null) break block4;
                Expression<Location> it = object;
                boolean bl = false;
                String string = " to " + it.toString(event, debug);
                object = string;
                if (string != null) break block5;
            }
            object = locationStr = "";
        }
        if ((expression = this.world) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("world");
            expression = null;
        }
        return "Unload slime world " + expression.toString(event, debug) + (String)(this.shouldTeleport ? " and teleport" + locationStr : "");
    }

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, "expressions");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<org.bukkit.World>");
        this.world = expression;
        SkriptParser.ParseResult parseResult2 = parseResult;
        boolean bl = this.shouldTeleport = parseResult2 != null ? parseResult2.hasTag("teleport") : false;
        if (expressions.length > 1 && expressions[1] != null) {
            Expression<?> expression2 = expressions[1];
            Intrinsics.checkNotNull(expression2, "null cannot be cast to non-null type ch.njol.skript.lang.Expression<org.bukkit.Location>");
            this.teleportLocation = expression2;
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Expression<World> expression = this.world;
        if (expression == null) {
            Intrinsics.throwUninitializedPropertyAccessException("world");
            expression = null;
        }
        World world = (World)expression.getSingle(event);
        if (world == null) {
            return;
        }
        World bukkitWorld = world;
        String string = bukkitWorld.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String worldNameValue = string;
        try {
            WorldData worldData = SlimeWorldUtils.requireWorldDataExists$default(SlimeWorldUtils.INSTANCE, worldNameValue, null, 2, null);
            Expression<Location> expression2 = this.teleportLocation;
            SlimeWorldUtils.INSTANCE.unloadWithOptionalTeleport(worldNameValue, bukkitWorld, worldData, this.shouldTeleport, expression2 != null ? (Location)expression2.getSingle(event) : null);
        }
        catch (IllegalArgumentException e) {
            Skript.error((String)e.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"unload (slimeworld|slime world) %world% [teleport:and teleport [to %-location%]]"};
        Skript.registerEffect(EffUnloadSlimeWorldByObject.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/danielmillar/slimelink/skript/effects/EffUnloadSlimeWorldByObject$Companion;", "", "<init>", "()V", "SlimeLink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

