/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.json.JsonArray;
import io.lettuce.core.json.JsonObject;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.json.JsonValue;
import java.nio.ByteBuffer;

class UnproccessedJsonValue
implements JsonValue {
    private volatile JsonValue jsonValue;
    private final JsonParser parser;
    private final ByteBuffer unprocessedData;

    public UnproccessedJsonValue(ByteBuffer bytes, JsonParser theParser) {
        this.unprocessedData = bytes;
        this.parser = theParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        if (this.isDeserialized()) {
            return this.jsonValue.toString();
        }
        UnproccessedJsonValue unproccessedJsonValue = this;
        synchronized (unproccessedJsonValue) {
            if (this.isDeserialized()) {
                return this.jsonValue.toString();
            }
            return StringCodec.UTF8.decodeValue(this.unprocessedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer asByteBuffer() {
        if (this.isDeserialized()) {
            return this.jsonValue.asByteBuffer();
        }
        UnproccessedJsonValue unproccessedJsonValue = this;
        synchronized (unproccessedJsonValue) {
            if (this.isDeserialized()) {
                return this.jsonValue.asByteBuffer();
            }
            return this.unprocessedData;
        }
    }

    @Override
    public boolean isJsonArray() {
        this.lazilyDeserialize();
        return this.jsonValue.isJsonArray();
    }

    @Override
    public JsonArray asJsonArray() {
        this.lazilyDeserialize();
        return this.jsonValue.asJsonArray();
    }

    @Override
    public boolean isJsonObject() {
        this.lazilyDeserialize();
        return this.jsonValue.isJsonObject();
    }

    @Override
    public JsonObject asJsonObject() {
        this.lazilyDeserialize();
        return this.jsonValue.asJsonObject();
    }

    @Override
    public boolean isString() {
        this.lazilyDeserialize();
        return this.jsonValue.isString();
    }

    @Override
    public String asString() {
        this.lazilyDeserialize();
        return this.jsonValue.asString();
    }

    @Override
    public boolean isNumber() {
        this.lazilyDeserialize();
        return this.jsonValue.isNumber();
    }

    @Override
    public Number asNumber() {
        this.lazilyDeserialize();
        return this.jsonValue.asNumber();
    }

    @Override
    public boolean isBoolean() {
        this.lazilyDeserialize();
        return this.jsonValue.isBoolean();
    }

    @Override
    public Boolean asBoolean() {
        this.lazilyDeserialize();
        return this.jsonValue.asBoolean();
    }

    @Override
    public boolean isNull() {
        this.lazilyDeserialize();
        return this.jsonValue.isNull();
    }

    @Override
    public <T> T toObject(Class<T> targetType) {
        this.lazilyDeserialize();
        return this.jsonValue.toObject(targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazilyDeserialize() {
        if (!this.isDeserialized()) {
            UnproccessedJsonValue unproccessedJsonValue = this;
            synchronized (unproccessedJsonValue) {
                if (!this.isDeserialized()) {
                    this.jsonValue = this.parser.createJsonValue(this.unprocessedData);
                    this.unprocessedData.clear();
                }
            }
        }
    }

    boolean isDeserialized() {
        return this.jsonValue != null;
    }
}

