/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.proxy;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.botanicadds.BotanicAdditions;
import org.zeith.botanicadds.api.FlowerHUD;
import org.zeith.botanicadds.client.particle.lightning.BoltParticle;
import org.zeith.botanicadds.init.ItemsBA;
import org.zeith.botanicadds.particle.BoltParticleType;
import org.zeith.botanicadds.proxy.CommonProxyBA;
import org.zeith.botanicadds.tiles.TileElvenBrewery;
import org.zeith.botanicadds.tiles.TileManaTesseract;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.forge.CapabilityUtil;

public class ClientProxyBA
extends CommonProxyBA {
    private static final Map<ResourceLocation, Set<ResourceLocation>> SPRITES_BY_ATLAS = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    public static final Material TERRA_CATALYST_OVERLAY = ClientProxyBA.register(new Material(InventoryMenu.f_39692_, BotanicAdditions.id("block/terra_catalyst_overlay")));

    public ClientProxyBA() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerItemColors);
        bus.addListener(this::registerMaterials);
        bus.addListener(this::clientSetup);
        bus.addListener(this::bindParticles);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, this::attachBeCapabilities);
    }

    private void bindParticles(RegisterParticleProvidersEvent e) {
        e.register((ParticleType)BoltParticleType.TYPE, (ParticleProvider)new BoltParticle.Provider());
    }

    private void clientSetup(FMLClientSetupEvent e) {
        ItemProperties.register((Item)ItemsBA.TESSERACT_ATTUNER, (ResourceLocation)new ResourceLocation("private"), (item, p_174626_, p_174627_, p_174628_) -> ItemsBA.TESSERACT_ATTUNER.isPrivate(item) ? 1.0f : 0.0f);
        ClientProxyBA.initRenderTypes(ItemBlockRenderTypes::setRenderLayer);
    }

    public static void initRenderTypes(BiConsumer<Block, RenderType> consumer) {
        ForgeRegistries.BLOCKS.getEntries().stream().filter(b -> ((ResourceKey)b.getKey()).m_135782_().m_135827_().equals("botanicadds")).forEach(e -> {
            Block b = (Block)e.getValue();
            if (b instanceof FloatingFlowerBlock || b instanceof FlowerBlock || b instanceof TallFlowerBlock || b instanceof BotaniaMushroomBlock) {
                consumer.accept(b, RenderType.m_110463_());
            }
        });
    }

    private void attachBeCapabilities(AttachCapabilitiesEvent<BlockEntity> e) {
        BindableSpecialFlowerBlockEntity gf;
        BlockEntity be = (BlockEntity)e.getObject();
        if (be instanceof BindableSpecialFlowerBlockEntity && (gf = (BindableSpecialFlowerBlockEntity)be).getClass().isAnnotationPresent(FlowerHUD.class)) {
            e.addCapability(BotanicAdditions.id("wand_hud"), CapabilityUtil.makeProvider((Capability)BotaniaForgeClientCapabilities.WAND_HUD, (Object)new BindableSpecialFlowerBlockEntity.BindableFlowerWandHud(gf)));
        }
        if (be instanceof TileManaTesseract) {
            TileManaTesseract tess = (TileManaTesseract)be;
            e.addCapability(BotanicAdditions.id("wand_hud"), CapabilityUtil.makeProvider((Capability)BotaniaForgeClientCapabilities.WAND_HUD, (Object)new TileManaTesseract.WandHud(tess)));
        }
        if (be instanceof TileElvenBrewery) {
            TileElvenBrewery brew = (TileElvenBrewery)be;
            e.addCapability(BotanicAdditions.id("wand_hud"), CapabilityUtil.makeProvider((Capability)BotaniaForgeClientCapabilities.WAND_HUD, (Object)new BreweryBlockEntity.WandHud((BreweryBlockEntity)brew)));
        }
    }

    public float getWorldElapsedTicks() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            return (float)mc.f_91073_.m_8044_() + mc.getPartialTick();
        }
        return 0.0f;
    }

    public void registerItemColors(RegisterColorHandlersEvent.Item e) {
        e.register((s, t) -> Color.HSBtoRGB(this.getWorldElapsedTicks() * 2.0f % 360.0f / 360.0f, 0.25f, 1.0f), new ItemLike[]{ItemsBA.GAIA_SHARD});
    }

    public void registerMaterials(TextureStitchEvent.Pre e) {
        SPRITES_BY_ATLAS.getOrDefault(e.getAtlas().m_118330_(), Set.of()).forEach(arg_0 -> ((TextureStitchEvent.Pre)e).addSprite(arg_0));
    }

    private static Material register(Material mat) {
        SPRITES_BY_ATLAS.computeIfAbsent(mat.m_119193_(), rl -> new HashSet()).add(mat.m_119203_());
        return mat;
    }
}

