/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles.flowers;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.FlowerHUD;
import org.zeith.botanicadds.init.FlowersBA;
import org.zeith.botanicadds.init.TagsBA;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

@FlowerHUD
public class Apicaria
extends FunctionalFlowerBlockEntity {
    public boolean hasOvergrownSoil;

    public Apicaria(BlockPos pos, BlockState state) {
        super(FlowersBA.APICARIA_TYPE, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        this.hasOvergrownSoil = this.overgrowth;
        int radius = this.getRange();
        if (this.getMana() > 150 && this.ticksExisted % 2 == 0) {
            List bees = this.f_58857_.m_6443_(Mob.class, new AABB(this.f_58858_).m_82400_((double)radius), b -> b.m_6095_().m_204039_(TagsBA.EntityTypes.BEES) && b.m_20183_().m_123314_((Vec3i)this.f_58858_, (double)radius));
            for (int i = 0; i < bees.size() && this.getMana() > 150; ++i) {
                Mob bee = (Mob)bees.get(i);
                if (!(bee.m_5448_() instanceof Player)) continue;
                bee.m_6710_(null);
                if (bee instanceof NeutralMob) {
                    NeutralMob nm = (NeutralMob)bee;
                    nm.m_21662_();
                }
                this.addMana(-150);
            }
        }
    }

    public boolean isOvergrowthAffected() {
        return false;
    }

    public int getRange() {
        return this.hasOvergrownSoil ? 16 : 8;
    }

    public int getMaxMana() {
        return 600;
    }

    public int getColor() {
        return 16753920;
    }

    public void addMana(int mana) {
        super.addMana(mana);
        if (mana < 0) {
            this.sync();
        }
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.f_58858_, (double)this.getRange());
    }

    public static boolean findActiveApicariaAndUseMana(Level level, BlockPos pos) {
        return Apicaria.findActiveApicaria(level, pos).map(a -> {
            if (!level.f_46443_) {
                boolean wasFromBlock = false;
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                for (int i = 4; i < Math.min(stackTrace.length, 16); ++i) {
                    StackTraceElement element = stackTrace[i];
                    try {
                        Class<?> callerClass = Block.class.getClassLoader().loadClass(element.getClassName());
                        if (CampfireBlock.class.isAssignableFrom(callerClass) || !Block.class.isAssignableFrom(callerClass)) continue;
                        wasFromBlock = true;
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (wasFromBlock) {
                    a.addMana(-150);
                }
            }
            return true;
        }).orElse(false);
    }

    public static Optional<Apicaria> findActiveApicaria(Level level, BlockPos pos) {
        return BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)pos.m_7918_(-16, -6, -16), (Vec3i)pos.m_7918_(16, 2, 16))).map(pos0 -> {
            Apicaria a;
            BlockEntity patt3434$temp = level.m_7702_(pos0);
            if (patt3434$temp instanceof Apicaria && a.f_58858_.m_123314_((Vec3i)pos, (double)(a = (Apicaria)patt3434$temp).getRange()) && a.getMana() >= 150) {
                return a;
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
    }
}

