/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.EnumMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.paradisemod.automation.Automation;
import net.paradisemod.base.Events;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.PMPaintings;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.DataGen;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredCreativeTab;
import net.paradisemod.bonus.Bonus;
import net.paradisemod.building.Building;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.misc.Misc;
import net.paradisemod.monsters.Monsters;
import net.paradisemod.redstone.Redstone;
import net.paradisemod.world.PMWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="paradisemod")
public class ParadiseMod {
    public static final EnumMap<DyeColor, Item> DYES_BY_COLOR = new EnumMap(DyeColor.class);
    public static final String ID = "paradisemod";
    public static final Logger LOG = LogManager.getLogger((String)"paradisemod");

    public ParadiseMod() {
        LOG.info("Setting up Paradise Mod");
        PMConfig.init(ModLoadingContext.get());
        IEventBus eventbus = FMLJavaModLoadingContext.get().getModEventBus();
        Utils.addToCreativeTab((ItemLike)Items.f_42751_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_);
        Utils.addToCreativeTab((ItemLike)Items.f_42750_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50678_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50677_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50454_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50272_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50448_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50447_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        Utils.addToCreativeTab((ItemLike)Blocks.f_50375_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
        Utils.addToCreativeTab((ItemLike)Items.f_42657_, (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_);
        PMPaintings.init(eventbus);
        Misc.init(eventbus);
        Bonus.init(eventbus);
        Redstone.init(eventbus);
        PMWorld.init(eventbus);
        Building.init();
        Decoration.init();
        Automation.init();
        Monsters.init();
        RegisteredCreativeTab.initTabs(eventbus);
        PMRegistries.init(eventbus);
        if (FMLEnvironment.dist.isClient()) {
            eventbus.addListener(Events.Client::colorBlocks);
            eventbus.addListener(Events.Client::colorItems);
            eventbus.addListener(event -> {
                Misc.initClient(event);
                Redstone.initClient();
                PMWorld.initClient(event);
                Monsters.initClient();
                MinecraftForge.EVENT_BUS.register(Events.Client.class);
                ParadiseMod.addResourcePacks();
                LOG.info("Minecraft is in client mode");
            });
        }
        eventbus.addListener(event -> LOG.info("Minecraft is in server mode"));
        eventbus.addListener(Events.Common::populateCreativeTabs);
        MinecraftForge.EVENT_BUS.register(Events.Common.class);
        eventbus.addListener(DataGen::generateData);
        LOG.info("Setup complete");
    }

    private static void addResourcePacks() {
        ParadiseMod.addResourcePack("Classic Panorama 1");
        ParadiseMod.addResourcePack("Classic Panorama 2");
        ParadiseMod.addResourcePack("Companions of Paradise Mod");
        ParadiseMod.addResourcePack("Dark Autumn Rebirth Panorama");
        ParadiseMod.addResourcePack("The Geotransition Panorama");
    }

    private static void addResourcePack(String packName) {
        File dir = new File(".", "resourcepacks");
        File target = new File(dir, packName + ".zip");
        File debugTarget = new File(dir, packName);
        if (!target.exists() && !debugTarget.exists()) {
            try {
                int len;
                dir.mkdirs();
                InputStream in = ParadiseMod.class.getResourceAsStream("/assets/paradisemod/resourcepacks/" + packName + ".zip");
                FileOutputStream out = new FileOutputStream(target);
                byte[] buf = new byte[16384];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
                LOG.info("Loaded resource pack " + packName);
            }
            catch (Exception yes) {
                yes.printStackTrace();
            }
        }
    }

    static {
        DYES_BY_COLOR.put(DyeColor.WHITE, Items.f_42535_);
        DYES_BY_COLOR.put(DyeColor.ORANGE, Items.f_42536_);
        DYES_BY_COLOR.put(DyeColor.MAGENTA, Items.f_42537_);
        DYES_BY_COLOR.put(DyeColor.LIGHT_BLUE, Items.f_42538_);
        DYES_BY_COLOR.put(DyeColor.YELLOW, Items.f_42539_);
        DYES_BY_COLOR.put(DyeColor.LIME, Items.f_42540_);
        DYES_BY_COLOR.put(DyeColor.PINK, Items.f_42489_);
        DYES_BY_COLOR.put(DyeColor.GRAY, Items.f_42490_);
        DYES_BY_COLOR.put(DyeColor.LIGHT_GRAY, Items.f_42491_);
        DYES_BY_COLOR.put(DyeColor.CYAN, Items.f_42492_);
        DYES_BY_COLOR.put(DyeColor.PURPLE, Items.f_42493_);
        DYES_BY_COLOR.put(DyeColor.BLUE, Items.f_42494_);
        DYES_BY_COLOR.put(DyeColor.BROWN, Items.f_42495_);
        DYES_BY_COLOR.put(DyeColor.GREEN, Items.f_42496_);
        DYES_BY_COLOR.put(DyeColor.RED, Items.f_42497_);
        DYES_BY_COLOR.put(DyeColor.BLACK, Items.f_42498_);
    }
}

