/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.automation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.automation.blocks.CustomFurnace;
import net.paradisemod.automation.blocks.CustomHopper;
import net.paradisemod.automation.tile.CustomFurnaceEntity;
import net.paradisemod.automation.tile.CustomHopperEntity;
import net.paradisemod.base.data.RecipeGenerator;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.world.DeepDarkBlocks;

public class Automation {
    public static final RegisteredBlock MOSSY_COBBLESTONE_FURNACE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("mossy_cobblestone_furnace", () -> new CustomFurnace(false)).tabs(CreativeModeTabs.f_256791_, CreativeModeTabs.f_257028_)).tag((TagKey<Block>)BlockTags.f_144282_).recipe((item, generator) -> Automation.furnaceRecipe(generator, (ItemLike)Blocks.f_50079_, (ItemLike)item))).localizedName("Mossy Cobblestone Furnace", "Horno de piedra labrada musgosa");
    public static final RegisteredBlock DARKSTONE_FURNACE = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("darkstone_furnace", () -> new CustomFurnace(true)).tabs(DeepDarkBlocks.DEEP_DARK_TAB.key(), CreativeModeTabs.f_256791_, CreativeModeTabs.f_257028_)).tag((TagKey<Block>)BlockTags.f_144282_).recipe((item, generator) -> Automation.furnaceRecipe(generator, DeepDarkBlocks.DARKSTONE, (ItemLike)item))).localizedName("Darkstone Furnace", "Horno de piedra oscura");
    public static final RegisteredBlock GOLD_HOPPER = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("gold_hopper", () -> new CustomHopper(1)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).tags(BlockTags.f_144282_, BlockTags.f_144285_).recipe((item, generator) -> Automation.hopperRecipe(generator, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (ItemLike)item))).localizedName("Golden Hopper", "Tolva dorada");
    public static final RegisteredBlock SILVER_HOPPER = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("silver_hopper", () -> new CustomHopper(2)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_257028_)).tags(BlockTags.f_144282_, BlockTags.f_144286_).recipe((item, generator) -> Automation.hopperRecipe(generator, PMTags.Items.SILVER_INGOTS, (ItemLike)item))).localizedName("Silver Hopper", "Tolva plateada");
    public static final RegisteredBlock EMERALD_RAIL = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("emerald_rail", () -> new RailBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50156_)){

        public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
            return 1.2f;
        }
    }).tabs(CreativeModeTabs.f_257028_, CreativeModeTabs.f_256869_)).itemModel(Automation::genRailItemModel).blockStateGenerator(Automation::genRailBlockState).tag((TagKey<Block>)BlockTags.f_13034_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 16).m_126130_("e e").m_126130_("ese").m_126130_("e e").m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_))).localizedName("Emerald Rail", "V\u00eda de esmeralda");
    public static final RegisteredBlock POWERED_EMERALD_RAIL = (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem("powered_emerald_rail", () -> new PoweredRailBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50030_), true){

        public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
            return 1.2f;
        }
    }).tabs(CreativeModeTabs.f_257028_, CreativeModeTabs.f_256869_)).itemModel((block, generator) -> generator.flatBlockItem((RegisteredBlock)block)).blockStateGenerator(Automation::genRailBlockState).tag((TagKey<Block>)BlockTags.f_13034_).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 6).m_126130_("gsg").m_126130_("geg").m_126130_("grg").m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('r'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42616_))).localizedName("Powered Emerald Rail", "V\u00eda propulsora de esmeralda");
    public static final RegistryObject<BlockEntityType<CustomFurnaceEntity>> CUSTOM_FURNACE_TILE = PMRegistries.createTile("custom_furnace", CustomFurnaceEntity::new, MOSSY_COBBLESTONE_FURNACE, DARKSTONE_FURNACE);
    public static final RegistryObject<BlockEntityType<CustomHopperEntity>> CUSTOM_HOPPER_TILE = PMRegistries.createTile("custom_hopper", CustomHopperEntity::new, GOLD_HOPPER, SILVER_HOPPER);

    public static void init() {
        ParadiseMod.LOG.info("Loaded Automation module");
    }

    private static void genRailItemModel(RegisteredBlock railBlock, ItemModelGenerator generator) {
        generator.flatBlockItem(railBlock);
    }

    private static void genRailBlockState(RegisteredBlock railBlock, BlockStateGenerator generator) {
        if (railBlock.shortName().contains("powered")) {
            generator.getVariantBuilder(railBlock.get()).forAllStates(state -> {
                boolean powered = (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_);
                RailShape shape = (RailShape)state.m_61143_((Property)PoweredRailBlock.f_55214_);
                String shortName = railBlock.shortName() + (powered ? "_on" : "");
                String name = switch (shape) {
                    case RailShape.ASCENDING_EAST, RailShape.ASCENDING_NORTH -> shortName + "_raised_ne";
                    case RailShape.ASCENDING_SOUTH, RailShape.ASCENDING_WEST -> shortName + "_raised_sw";
                    default -> shortName;
                };
                Direction dir = switch (shape) {
                    case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.EAST_WEST -> Direction.EAST;
                    default -> Direction.NORTH;
                };
                return generator.buildVariantModel((ModelFile)generator.existingModel(name), dir, true);
            });
        } else {
            generator.getVariantBuilder(railBlock.get()).forAllStates(state -> {
                RailShape shape = (RailShape)state.m_61143_((Property)RailBlock.f_55392_);
                Object modelName = switch (shape) {
                    case RailShape.ASCENDING_EAST, RailShape.ASCENDING_NORTH -> railBlock.shortName() + "_raised_ne";
                    case RailShape.ASCENDING_SOUTH, RailShape.ASCENDING_WEST -> railBlock.shortName() + "_raised_sw";
                    case RailShape.NORTH_EAST, RailShape.NORTH_WEST, RailShape.SOUTH_EAST, RailShape.SOUTH_WEST -> railBlock.shortName() + "_corner";
                    default -> railBlock.shortName();
                };
                Direction dir = switch (shape) {
                    case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.SOUTH_WEST, RailShape.EAST_WEST -> Direction.EAST;
                    case RailShape.NORTH_EAST -> Direction.WEST;
                    case RailShape.NORTH_WEST -> Direction.SOUTH;
                    default -> Direction.NORTH;
                };
                return generator.buildVariantModel((ModelFile)generator.existingModel((String)modelName), dir, true);
            });
        }
    }

    private static ShapedRecipeBuilder furnaceRecipe(RecipeGenerator generator, ItemLike input, ItemLike result) {
        return generator.getShapedBuilder(RecipeCategory.MISC, result).m_126130_("###").m_126130_("# #").m_126130_("###").m_126127_(Character.valueOf('#'), input);
    }

    private static ShapedRecipeBuilder hopperRecipe(RecipeGenerator generator, TagKey<Item> input, ItemLike result) {
        return generator.getShapedBuilder(RecipeCategory.MISC, result).m_126130_("I I").m_126130_("ICI").m_126130_(" I ").m_206416_(Character.valueOf('I'), input).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS);
    }
}

