/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.automation.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.automation.tile.CustomFurnaceEntity;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;

public class CustomFurnace
extends FurnaceBlock
implements ModeledBlock {
    private final boolean dark;

    public CustomFurnace(boolean isDark) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50094_));
        this.dark = isDark;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CustomFurnaceEntity(pos, state, this.dark);
    }

    public void m_7137_(Level world, BlockPos pos, Player player) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof CustomFurnaceEntity) {
            CustomFurnaceEntity furnace = (CustomFurnaceEntity)tile;
            player.m_5893_((MenuProvider)furnace);
            player.m_36220_(Stats.f_12966_);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)f_48684_)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            int d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rand.m_188500_() < 0.1) {
                world.m_7785_(d0, (double)d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)f_48683_);
            Direction.Axis axis = direction.m_122434_();
            double d4 = rand.m_188500_() * 0.6 - 0.3;
            double d5 = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = rand.m_188500_() * 6.0 / 16.0;
            double d7 = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, (double)d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            if (this.dark) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0 + d5, (double)d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            } else {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, (double)d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        String name = this.shortName();
        String furnaceName = name.substring(0, name.length() - 8);
        ((ItemModelBuilder)generator.getBuilder(name)).parent((ModelFile)generator.existingModel("block/furnace/" + furnaceName));
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        String name = this.shortName();
        String furnaceName = name.substring(0, name.length() - 8);
        ModelFile.ExistingModelFile model = generator.existingModel("furnace/" + furnaceName);
        ModelFile.ExistingModelFile litModel = generator.existingModel("furnace/" + furnaceName + "_on");
        generator.getVariantBuilder((Block)this).forAllStates(state -> generator.buildVariantModel((ModelFile)((Boolean)state.m_61143_((Property)f_48684_) != false ? litModel : model), (Direction)state.m_61143_((Property)f_48683_), true));
    }
}

