/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.automation.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.paradisemod.automation.Automation;
import net.paradisemod.automation.tile.CustomHopperEntity;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;

public class CustomHopper
extends HopperBlock
implements ModeledBlock {
    private final int rate;

    public CustomHopper(int itemRate) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50332_));
        this.rate = itemRate;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CustomHopperEntity(pos, state, this.rate);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile;
        if (stack.m_41788_() && (tile = world.m_7702_(pos)) instanceof CustomHopperEntity) {
            CustomHopperEntity hopper = (CustomHopperEntity)tile;
            hopper.m_58638_(stack.m_41786_());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof CustomHopperEntity) {
            CustomHopperEntity hopper = (CustomHopperEntity)tile;
            player.m_5893_((MenuProvider)hopper);
            player.m_36220_(Stats.f_12957_);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof CustomHopperEntity) {
                CustomHopperEntity hopper = (CustomHopperEntity)tile;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)hopper);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof CustomHopperEntity) {
            CustomHopperEntity hopper = (CustomHopperEntity)tile;
            CustomHopperEntity.entityInside(world, pos, state, entity, hopper);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> tileType) {
        return world.f_46443_ ? null : CustomHopper.m_152132_(tileType, (BlockEntityType)((BlockEntityType)Automation.CUSTOM_HOPPER_TILE.get()), CustomHopperEntity::pushItemsTick);
    }

    @Override
    public void genItemModel(ItemModelGenerator generator) {
        generator.basicItem(this.m_5456_());
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        String name = this.shortName();
        String hopperName = name.substring(0, name.length() - 7);
        ModelFile.ExistingModelFile downModel = generator.existingModel("hopper/" + hopperName);
        ModelFile.ExistingModelFile sideModel = generator.existingModel("hopper/" + hopperName + "_side");
        generator.getVariantBuilder((Block)this).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)f_54021_);
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder = dir == Direction.DOWN ? builder.modelFile((ModelFile)downModel) : builder.modelFile((ModelFile)sideModel).rotationY(BlockStateGenerator.calcYRot(dir));
            return builder.build();
        }, new Property[]{f_54022_});
    }
}

