/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.automation.tile;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import net.paradisemod.automation.Automation;

public class CustomHopperEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    private final int rate;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int cooldownTime = -1;
    private long tickedGameTime;

    public CustomHopperEntity(BlockPos pos, BlockState state, int itemRate) {
        super((BlockEntityType)Automation.CUSTOM_HOPPER_TILE.get(), pos, state);
        this.rate = itemRate;
    }

    public CustomHopperEntity(BlockPos pos, BlockState state) {
        this(pos, state, 64);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
        this.cooldownTime = tag.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
        tag.m_128405_("TransferCooldown", this.cooldownTime);
    }

    public int m_6643_() {
        return 5;
    }

    public ItemStack m_7407_(int index, int count) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)count);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.m_59640_(null);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.hopper");
    }

    public static void pushItemsTick(Level world, BlockPos pos, BlockState state, CustomHopperEntity hopper) {
        --hopper.cooldownTime;
        hopper.tickedGameTime = world.m_46467_();
        if (!hopper.isOnCooldown()) {
            hopper.setCooldown(0);
            CustomHopperEntity.tryMoveItems(world, pos, state, hopper, () -> CustomHopperEntity.suckInItems(world, hopper));
        }
    }

    private static boolean tryMoveItems(Level world, BlockPos pos, BlockState state, CustomHopperEntity hopper, BooleanSupplier validator) {
        if (!world.f_46443_ && !hopper.isOnCooldown() && ((Boolean)state.m_61143_((Property)HopperBlock.f_54022_)).booleanValue()) {
            boolean flag = false;
            if (!hopper.m_7983_()) {
                flag = CustomHopperEntity.ejectItems(world, pos, state, hopper);
            }
            if (!hopper.inventoryFull()) {
                flag |= validator.getAsBoolean();
            }
            if (flag) {
                hopper.setCooldown(hopper.rate);
                CustomHopperEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level world, BlockPos pos, BlockState state, CustomHopperEntity sourceHopper) {
        Direction direction;
        Container container = CustomHopperEntity.getAttachedContainer(world, pos, state);
        if (container != null && !CustomHopperEntity.isFullContainer(container, direction = ((Direction)state.m_61143_((Property)HopperBlock.f_54021_)).m_122424_())) {
            for (int i = 0; i < sourceHopper.m_6643_(); ++i) {
                if (sourceHopper.m_8020_(i).m_41619_()) continue;
                ItemStack itemstack = sourceHopper.m_8020_(i).m_41777_();
                ItemStack itemstack1 = CustomHopperEntity.addItem((Container)sourceHopper, container, sourceHopper.m_7407_(i, 1), direction);
                if (itemstack1.m_41619_()) {
                    container.m_6596_();
                    return true;
                }
                sourceHopper.m_6836_(i, itemstack);
            }
        }
        return false;
    }

    private static IntStream getSlots(Container container, Direction direction) {
        return container instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)container).m_7071_(direction)) : IntStream.range(0, container.m_6643_());
    }

    private static boolean isFullContainer(Container container, Direction direction) {
        return CustomHopperEntity.getSlots(container, direction).allMatch(slot -> {
            ItemStack itemstack = container.m_8020_(slot);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    private static boolean isEmptyContainer(Container container, Direction direction) {
        return CustomHopperEntity.getSlots(container, direction).allMatch(slot -> container.m_8020_(slot).m_41619_());
    }

    public static boolean suckInItems(Level world, Hopper hopper) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((Level)world, (Hopper)hopper);
        if (ret != null) {
            return ret;
        }
        Container container = CustomHopperEntity.getSourceContainer(world, hopper);
        if (container != null) {
            Direction direction = Direction.DOWN;
            return !CustomHopperEntity.isEmptyContainer(container, direction) && CustomHopperEntity.getSlots(container, direction).anyMatch(slot -> CustomHopperEntity.tryTakeInItemFromSlot(hopper, container, slot, direction));
        }
        for (ItemEntity itementity : CustomHopperEntity.getItemsAtAndAbove(world, hopper)) {
            if (!CustomHopperEntity.addItem((Container)hopper, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(Hopper hopper, Container container, int slot, Direction direction) {
        ItemStack itemstack = container.m_8020_(slot);
        if (!itemstack.m_41619_() && CustomHopperEntity.canTakeItemFromContainer(container, itemstack, slot, direction)) {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack itemstack2 = CustomHopperEntity.addItem(container, (Container)hopper, container.m_7407_(slot, 1), null);
            if (itemstack2.m_41619_()) {
                container.m_6596_();
                return true;
            }
            container.m_6836_(slot, itemstack1);
        }
        return false;
    }

    public static boolean addItem(Container container, ItemEntity item) {
        boolean flag = false;
        ItemStack itemstack = item.m_32055_().m_41777_();
        ItemStack itemstack1 = CustomHopperEntity.addItem(null, container, itemstack, null);
        if (itemstack1.m_41619_()) {
            flag = true;
            item.m_146870_();
        } else {
            item.m_32045_(itemstack1);
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack addItem(@Nullable Container source, Container destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof WorldlyContainer) {
            WorldlyContainer container = (WorldlyContainer)destination;
            if (direction != null) {
                int[] nArray = container.m_7071_(direction);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int slot = nArray[n2];
                    stack = CustomHopperEntity.tryMoveInItem(source, destination, stack, slot, direction);
                    ++n2;
                }
                return stack;
            }
        }
        int i = destination.m_6643_();
        int j = 0;
        while (j < i) {
            if (stack.m_41619_()) return stack;
            stack = CustomHopperEntity.tryMoveInItem(source, destination, stack, j, direction);
            ++j;
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container container, ItemStack stack, int pslot, @Nullable Direction direction) {
        if (!container.m_7013_(pslot, stack)) {
            return false;
        }
        return !(container instanceof WorldlyContainer) || ((WorldlyContainer)container).m_7155_(pslot, stack, direction);
    }

    private static boolean canTakeItemFromContainer(Container container, ItemStack stack, int slot, Direction direction) {
        return !(container instanceof WorldlyContainer) || ((WorldlyContainer)container).m_7157_(slot, stack, direction);
    }

    private static ItemStack tryMoveInItem(@Nullable Container source, Container destination, ItemStack stack, int slot, @Nullable Direction direction) {
        ItemStack itemstack = destination.m_8020_(slot);
        if (CustomHopperEntity.canPlaceItemInContainer(destination, stack, slot, direction)) {
            boolean flag = false;
            boolean flag1 = destination.m_7983_();
            if (itemstack.m_41619_()) {
                destination.m_6836_(slot, stack);
                stack = ItemStack.f_41583_;
                flag = true;
            } else if (CustomHopperEntity.canMergeItems(itemstack, stack)) {
                int i = stack.m_41741_() - itemstack.m_41613_();
                int j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                itemstack.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                CustomHopperEntity hopperblockentity1;
                if (flag1 && destination instanceof CustomHopperEntity && !(hopperblockentity1 = (CustomHopperEntity)destination).isOnCustomCooldown()) {
                    int k = 0;
                    if (source instanceof CustomHopperEntity) {
                        CustomHopperEntity hopperblockentity = (CustomHopperEntity)source;
                        if (hopperblockentity1.tickedGameTime >= hopperblockentity.tickedGameTime) {
                            k = 1;
                        }
                    }
                    hopperblockentity1.setCooldown(8 - k);
                }
                destination.m_6596_();
            }
        }
        return stack;
    }

    @Nullable
    private static Container getAttachedContainer(Level world, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)HopperBlock.f_54021_);
        return CustomHopperEntity.getContainerAt(world, pos.m_121945_(direction));
    }

    @Nullable
    private static Container getSourceContainer(Level world, Hopper hopper) {
        return CustomHopperEntity.getContainerAt(world, hopper.m_6343_(), hopper.m_6358_() + 1.0, hopper.m_6446_());
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level world, Hopper hopper) {
        return hopper.m_59300_().m_83299_().stream().flatMap(bounds -> world.m_6443_(ItemEntity.class, bounds.m_82386_(hopper.m_6343_() - 0.5, hopper.m_6358_() - 0.5, hopper.m_6446_() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static Container getContainerAt(Level world, BlockPos pos) {
        return CustomHopperEntity.getContainerAt(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @Nullable
    private static Container getContainerAt(Level world, double x, double y, double z) {
        List entities;
        Container containerTile;
        BlockEntity tile;
        WorldlyContainer container = null;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockState blockstate = world.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder containerBlock = (WorldlyContainerHolder)block;
            container = containerBlock.m_5840_(blockstate, (LevelAccessor)world, blockpos);
        } else if (blockstate.m_155947_() && (tile = world.m_7702_(blockpos)) instanceof Container && (container = (containerTile = (Container)tile)) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            ChestBlock chest = (ChestBlock)block;
            container = ChestBlock.m_51511_((ChestBlock)chest, (BlockState)blockstate, (Level)world, (BlockPos)blockpos, (boolean)true);
        }
        if (container == null && !(entities = world.m_6249_((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            container = (Container)entities.get(world.f_46441_.m_188503_(entities.size()));
        }
        return container;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_150930_(stack2.m_41720_())) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        if (stack1.m_41613_() > stack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public void setCooldown(int time) {
        this.cooldownTime = time;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public static void entityInside(Level world, BlockPos pos, BlockState state, Entity entity, CustomHopperEntity hopper) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()))), (VoxelShape)hopper.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
                CustomHopperEntity.tryMoveItems(world, pos, state, hopper, () -> CustomHopperEntity.addItem((Container)hopper, item));
            }
        }
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new HopperMenu(id, inventory, (Container)this);
    }
}

