/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.BlockType;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.decoration.blocks.CustomWood;
import net.paradisemod.misc.blocks.CustomBarrel;
import net.paradisemod.misc.blocks.CustomHangingSign;
import net.paradisemod.misc.blocks.CustomSign;
import net.paradisemod.misc.blocks.CustomWallHangingSign;
import net.paradisemod.misc.blocks.CustomWallSign;

public class BlockTemplates {
    public static RegisteredBlock planks(String woodName, boolean glows) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(woodName + "_planks", () -> new Block(BlockType.WOOD.getProperties().m_60953_(s -> glows ? 7 : 0))).tag((TagKey<Block>)BlockTags.f_13090_).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, 4).m_126130_("LL").m_126130_("LL").m_206416_(Character.valueOf('L'), BlockTemplates.logTagItem(woodName)))).localizedName(Utils.localizedMaterialName(woodName, false) + " Planks", "Tablones de " + Utils.localizedMaterialName(woodName, true));
    }

    public static RegisteredBlock rock(String name) {
        return (RegisteredBlock)PMRegistries.regBlockItem(name, () -> new Block(BlockType.STONE.getProperties())).tags(BlockTags.f_144282_, Tags.Blocks.STONE).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    }

    public static RegisteredBlock rock(String name, ItemLike craftFromBlock) {
        return BlockTemplates.rockInternal(name, craftFromBlock, BlockType.STONE.getProperties());
    }

    public static RegisteredBlock rock(String name, Block vanillaRockToCopy) {
        return BlockTemplates.rockInternal(name, (ItemLike)vanillaRockToCopy, BlockBehaviour.Properties.m_60926_((BlockBehaviour)vanillaRockToCopy));
    }

    public static RegisteredBlock cutRock(String name, ItemLike craftFromBlock, ItemLike ... blocksToStoneCutFrom) {
        return BlockTemplates.cutRockInternal(name, craftFromBlock, BlockType.STONE.getProperties(), blocksToStoneCutFrom);
    }

    public static RegisteredBlock cutRock(String name, Block vanillaRockToCopy, ItemLike ... blocksToStoneCutFrom) {
        return BlockTemplates.cutRockInternal(name, (ItemLike)vanillaRockToCopy, BlockBehaviour.Properties.m_60926_((BlockBehaviour)vanillaRockToCopy), blocksToStoneCutFrom);
    }

    public static RegisteredBlock improvedRock(String name) {
        return (RegisteredBlock)PMRegistries.regBlockItem(name, () -> new Block(BlockType.ENHANCED_STONE.getProperties())).tags(BlockTags.f_144282_, Tags.Blocks.STONE).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    }

    public static RegisteredBlock improvedRock(String name, ItemLike craftFromBlock) {
        return BlockTemplates.rockInternal(name, craftFromBlock, BlockType.ENHANCED_STONE.getProperties());
    }

    public static RegisteredBlock cutImprovedRock(String name, ItemLike craftFromBlock, ItemLike ... blocksToStoneCutFrom) {
        return BlockTemplates.cutRockInternal(name, craftFromBlock, BlockType.ENHANCED_STONE.getProperties(), new ItemLike[0]);
    }

    private static RegisteredBlock rockInternal(String name, ItemLike craftFromBlock, BlockBehaviour.Properties props) {
        RegisteredBlock block = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name, () -> new Block(props)).tags(BlockTags.f_144282_, Tags.Blocks.STONE).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).recipe((item, generator) -> generator.stonecutterRecipe(craftFromBlock, (ItemLike)item));
        if (!name.contains("chiseled")) {
            block = (RegisteredBlock)block.recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("rr").m_126130_("rr").m_126127_(Character.valueOf('r'), craftFromBlock));
        }
        return block;
    }

    public static RegisteredBlock cutRockInternal(String name, ItemLike craftFromBlock, BlockBehaviour.Properties props, ItemLike ... blocksToStoneCutFrom) {
        ArrayList<ItemLike> stonecutterBlocks = new ArrayList<ItemLike>(List.of(blocksToStoneCutFrom));
        stonecutterBlocks.add(craftFromBlock);
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name, () -> new Block(BlockType.STONE.getProperties())).tags(BlockTags.f_144282_, BlockTags.f_144287_).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)item).m_126130_("rr").m_126130_("rr").m_126127_(Character.valueOf('r'), craftFromBlock))).stonecutterRecipes((ItemLike[])stonecutterBlocks.toArray(ItemLike[]::new));
    }

    public static RegisteredBlock log(String name, boolean isWood, Supplier<Block> strippedLog, boolean glows) {
        String logName = name + (isWood ? "_wood" : "_log");
        RegisteredBlock log = (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(logName, () -> new CustomWood((Block)strippedLog.get(), glows)).blockStateGenerator((block, generator) -> BlockTemplates.logBlockState(name, isWood, false, block, generator)).tag(BlockTemplates.logTag(name)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).localizedName(Utils.localizedMaterialName(name, false) + " " + (isWood ? "Wood" : "Log"), (isWood ? "Le\u00f1o" : "Tronco") + " de " + Utils.localizedMaterialName(name, true));
        if (!isWood) {
            log = (RegisteredBlock)log.tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_);
        }
        return log;
    }

    public static RegisteredBlock strippedLog(String name, boolean isWood, boolean glows) {
        String logName = "stripped_" + name + (isWood ? "_wood" : "_log");
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(logName, () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_60953_(s -> glows ? 7 : 0))).tag(BlockTemplates.logTag(name)).blockStateGenerator((block, generator) -> BlockTemplates.logBlockState(name, isWood, true, block, generator)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_)).localizedName("Stripped " + Utils.localizedMaterialName(name, false) + " " + (isWood ? "Wood" : "Log"), (isWood ? "Le\u00f1o" : "Tronco") + " de " + Utils.localizedMaterialName(name, true) + " sin corteza");
    }

    public static RegisteredBlock leaves(final String name, String vanillaLeavesName, RegisteredBlock sapling, boolean glows) {
        return (RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60953_(s -> glows ? 7 : 0)){

            public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
                if (name == "glowing_oak") {
                    world.m_7260_(pos, state, state, 8);
                }
            }
        }).tag((TagKey<Block>)BlockTags.f_13035_).renderType("cutout").lootTable((block, generator) -> generator.leavesDrop((Block)block, sapling.get())).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256776_)).blockStateGenerator((block, generator) -> generator.vanillaTintedLeaves((RegisteredBlock)block, vanillaLeavesName)).localizedName(Utils.localizedMaterialName(name, false) + " Leaves", "Hojas de " + Utils.localizedMaterialName(name, true));
    }

    public static RegisteredBlock barrel(String name, boolean glows, ItemLike planks, ItemLike woodSlab) {
        return (RegisteredBlock)((RegisteredBlock)((RegisteredBlock)PMRegistries.regBlockItem(name + "_barrel", () -> new CustomBarrel(glows ? 7 : 0)).itemModel((block, generator) -> generator.parentBlockItem((RegisteredBlock)block, "barrel/" + name)).blockStateGenerator((block, generator) -> {
            BlockModelProvider modelBuilder = generator.models();
            String topTexture = "block/barrel/" + name + "_top";
            String topOpenTexture = "block/barrel/" + name + "_top_open";
            String bottomTexture = "block/barrel/" + name + "_bottom";
            String sideTexture = "block/barrel/" + name + "_side";
            BlockModelBuilder barrel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.getBuilder("block/barrel/" + name)).parent((ModelFile)generator.existingMCModel("cube_bottom_top"))).texture("top", topTexture)).texture("bottom", bottomTexture)).texture("side", sideTexture);
            BlockModelBuilder open = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)modelBuilder.getBuilder("block/barrel/" + name + "_open")).parent((ModelFile)generator.existingMCModel("cube_bottom_top"))).texture("top", topOpenTexture)).texture("bottom", bottomTexture)).texture("side", sideTexture);
            generator.getVariantBuilder(block.get()).forAllStates(state -> {
                Direction facing = (Direction)state.m_61143_((Property)BarrelBlock.f_49042_);
                boolean isOpen = (Boolean)state.m_61143_((Property)BarrelBlock.f_49043_);
                if (isOpen) {
                    return generator.buildVariantModel((ModelFile)open, facing);
                }
                return generator.buildVariantModel((ModelFile)barrel, facing);
            });
        }).tags(BlockTags.f_144280_, Tags.Blocks.BARRELS_WOODEN).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item).m_126130_("PSP").m_126130_("P P").m_126130_("PSP").m_126127_(Character.valueOf('P'), planks).m_126127_(Character.valueOf('S'), woodSlab))).localizedName(Utils.localizedMaterialName(name, false) + " Barrel", (name == "crimson" || name == "warped" ? "Barril " : "Barril de ") + Utils.localizedMaterialName(name, true));
    }

    public static RegisteredBlock sign(String name, WoodType woodType, boolean isWallSign, boolean glows) {
        int lightLevel = glows ? 7 : 0;
        Supplier<Block> sign = isWallSign ? () -> new CustomWallSign(woodType, lightLevel) : () -> new CustomSign(woodType, lightLevel);
        String signName = name + (isWallSign ? "_wall" : "") + "_sign";
        TagKey signTag = isWallSign ? BlockTags.f_13067_ : BlockTags.f_13066_;
        String particleTex = name.contains("cactus") ? "block/" + name + "_block" : "block/" + name + "_planks";
        return PMRegistries.regBlock(signName, sign).tag((TagKey<Block>)signTag).blockStateGenerator((block, generator) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().getBuilder("block/sign/" + name)).texture("particle", particleTex);
            generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
        });
    }

    public static RegisteredItem signItem(String name, Supplier<Block> sign, Supplier<Block> wallSign, ItemLike planks) {
        return (RegisteredItem)((RegisteredItem)((RegisteredItem)PMRegistries.regItem(name + "_sign", () -> new SignItem(new Item.Properties(), (Block)sign.get(), (Block)wallSign.get())).model((item, generator) -> generator.basicItem(item.get(), "sign/" + name)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 3).m_126130_("PPP").m_126130_("PPP").m_126130_(" S ").m_126127_(Character.valueOf('P'), planks).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_))).localizedName(Utils.localizedMaterialName(name, false) + " Sign", "Letrero de " + Utils.localizedMaterialName(name, true));
    }

    public static RegisteredBlock hangingSign(String name, WoodType woodType, boolean isWallSign, boolean glows) {
        int lightLevel = glows ? 7 : 0;
        Supplier<Block> sign = isWallSign ? () -> new CustomWallHangingSign(woodType, lightLevel) : () -> new CustomHangingSign(woodType, lightLevel);
        String signName = name + (isWallSign ? "_wall" : "") + "_hanging_sign";
        TagKey signTag = isWallSign ? BlockTags.f_244544_ : BlockTags.f_243838_;
        String particleTex = name.contains("cactus") ? "block/" + name + "_block" : "block/" + name + "_planks";
        return PMRegistries.regBlock(signName, sign).tag((TagKey<Block>)signTag).blockStateGenerator((block, generator) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)generator.models().getBuilder("block/hanging_sign/" + name)).texture("particle", particleTex);
            generator.simpleBlock((RegisteredBlock)block, (ModelFile)model);
        });
    }

    public static RegisteredItem hangingSignItem(String name, Supplier<Block> sign, Supplier<Block> wallSign, ItemLike planks) {
        return (RegisteredItem)((RegisteredItem)((RegisteredItem)PMRegistries.regItem(name + "_hanging_sign", () -> new HangingSignItem((Block)sign.get(), (Block)wallSign.get(), new Item.Properties())).model((item, generator) -> generator.basicItem(item.get(), "hanging_sign/" + name)).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_)).recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item, 6).m_126130_("C C").m_126130_("PPP").m_126130_("PPP").m_126127_(Character.valueOf('P'), planks).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50184_))).localizedName(Utils.localizedMaterialName(name, false) + " Hanging Sign", "Letrero colgante de " + Utils.localizedMaterialName(name, true));
    }

    public static TagKey<Block> logTag(String logName) {
        return PMTags.createModTag(logName + "_logs", Registries.f_256747_);
    }

    public static TagKey<Item> logTagItem(String logName) {
        return PMTags.createModTag(logName + "_logs", Registries.f_256913_);
    }

    private static void logBlockState(String name, boolean isWood, boolean stripped, RegisteredBlock block, BlockStateGenerator generator) {
        String logName = (stripped ? "stripped_" : "") + name;
        ResourceLocation texture = generator.modLoc("block/" + logName + "_log");
        ResourceLocation topTexture = generator.modLoc("block/" + logName + "_log_top");
        BlockModelProvider modelBuilder = generator.models();
        if (isWood) {
            BlockModelBuilder model = (BlockModelBuilder)modelBuilder.cubeColumn(logName + "_wood", texture, texture);
            generator.axisBlock((RotatedPillarBlock)block.get(), (ModelFile)model, (ModelFile)model);
        } else {
            BlockModelBuilder vertical = (BlockModelBuilder)modelBuilder.cubeColumn(logName + "_log", texture, topTexture);
            BlockModelBuilder horizontal = (BlockModelBuilder)modelBuilder.cubeColumnHorizontal(name + "_log_horizontal", texture, topTexture);
            generator.axisBlock((RotatedPillarBlock)block.get(), (ModelFile)vertical, (ModelFile)horizontal);
        }
    }
}

