/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base;

import java.util.Arrays;
import java.util.List;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public enum BlockType {
    GLASS(SoundType.f_56744_, 0.3f, 0.3f, new TagKey[0]),
    SOIL(SoundType.f_56739_, 0.5f, 0.5f, BlockTags.f_144283_),
    WOOD(SoundType.f_56736_, 2.5f, 2.5f, BlockTags.f_144280_),
    WEAK_METAL(SoundType.f_56743_, 6.0f, 6.0f, BlockTags.f_144282_, BlockTags.f_144286_),
    STONE(SoundType.f_56742_, 1.5f, 6.0f, BlockTags.f_144282_),
    METAL(SoundType.f_56743_, 6.0f, 6.0f, BlockTags.f_144282_, BlockTags.f_144285_),
    NETHERITE_LIKE(SoundType.f_56725_, 50.0f, 1200.0f, BlockTags.f_144282_, BlockTags.f_144284_),
    ENHANCED_STONE(SoundType.f_56742_, 3.0f, 9.0f, BlockTags.f_144282_),
    STRONG_STONE(SoundType.f_56742_, 50.0f, 1200.0f, BlockTags.f_144282_, BlockTags.f_144284_),
    INDESTRUCTIBLE(SoundType.f_56742_, -1.0f, 6000000.0f, new TagKey[0]);

    private final SoundType sound;
    private final float hardness;
    private final float resistance;
    private final List<TagKey<Block>> tags;

    @SafeVarargs
    private BlockType(SoundType sound, float hardness, float resistance, TagKey<Block> ... tags) {
        this.sound = sound;
        this.hardness = hardness;
        this.resistance = resistance;
        this.tags = Arrays.asList(tags);
    }

    public BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.getBlock()).m_60918_(this.sound).m_60913_(this.hardness, this.resistance);
        return switch (this) {
            case STRONG_STONE, WEAK_METAL, METAL, STONE, ENHANCED_STONE -> properties.m_60999_();
            default -> properties;
        };
    }

    public Block getBlock() {
        return switch (this) {
            default -> Blocks.f_50493_;
            case WOOD -> Blocks.f_50705_;
            case GLASS -> Blocks.f_50058_;
            case METAL -> Blocks.f_50074_;
            case STONE -> Blocks.f_50069_;
            case WEAK_METAL -> Blocks.f_50075_;
            case STRONG_STONE -> Blocks.f_50080_;
            case ENHANCED_STONE -> Blocks.f_50259_;
            case INDESTRUCTIBLE -> Blocks.f_50752_;
        };
    }

    public List<TagKey<Block>> tags() {
        return this.tags;
    }

    public boolean isStone() {
        return switch (this) {
            case STRONG_STONE, STONE, ENHANCED_STONE, INDESTRUCTIBLE -> true;
            default -> false;
        };
    }

    public boolean isMetal() {
        return switch (this) {
            case WEAK_METAL, METAL, NETHERITE_LIKE -> true;
            default -> false;
        };
    }
}

