/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.RainbowColor;
import net.paradisemod.base.Utils;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.building.Building;
import net.paradisemod.misc.Misc;
import net.paradisemod.redstone.Redstone;
import net.paradisemod.redstone.blocks.RedstoneWire;
import net.paradisemod.world.blocks.CustomCauldron;
import net.paradisemod.world.fluid.PMFluids;

public class Events {
    public static RainbowColor RAINBOW_COLOR = new RainbowColor();
    private static ArrayList<RegisteredBlock> RAINBOW_BLOCKS = new ArrayList();
    private static ArrayList<RegisteredBlock> GRASS_COLORED_BLOCKS = new ArrayList();
    private static ArrayListMultimap<Integer, RegisteredBlock> COLORED_BLOCKS = ArrayListMultimap.create();

    public static void registerBasicColoredBlocks(int color, RegisteredBlock ... blocks) {
        for (RegisteredBlock block : blocks) {
            COLORED_BLOCKS.put((Object)color, (Object)block);
        }
    }

    public static void registerGrassColoredBlocks(RegisteredBlock ... blocks) {
        for (RegisteredBlock block : blocks) {
            GRASS_COLORED_BLOCKS.add(block);
        }
    }

    public static void registerRainbowBlocks(RegisteredBlock ... blocks) {
        for (RegisteredBlock block : blocks) {
            RAINBOW_BLOCKS.add(block);
        }
    }

    public static class Client {
        @SubscribeEvent
        public static void bannerInfo(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (!(stack.m_41720_() instanceof BannerItem)) {
                return;
            }
            TooltipFlag flags = event.getFlags();
            Component name = stack.m_41786_();
            List tooltip = event.getToolTip();
            tooltip.clear();
            tooltip.add(name);
            CompoundTag compoundtag = stack.m_41737_("BlockEntityTag");
            if (compoundtag != null && compoundtag.m_128441_("Patterns")) {
                ListTag patterns = compoundtag.m_128437_("Patterns", 10);
                for (int i = 0; i < patterns.size(); ++i) {
                    CompoundTag patternTag = patterns.m_128728_(i);
                    DyeColor dyecolor = DyeColor.m_41053_((int)patternTag.m_128451_("Color"));
                    Holder pattern = BannerPattern.m_222700_((String)patternTag.m_128461_("Pattern"));
                    if (pattern == null) continue;
                    pattern.m_203543_().map(pat -> pat.m_135782_().m_214299_()).ifPresent(pat -> {
                        ResourceLocation fileLoc = new ResourceLocation(pat);
                        tooltip.add(Component.m_237115_((String)("block." + fileLoc.m_135827_() + ".banner." + fileLoc.m_135815_() + "." + dyecolor.m_41065_())).m_130940_(ChatFormatting.GRAY));
                    });
                }
            }
            if (flags.m_7050_()) {
                tooltip.add(Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }

        public static void colorItems(RegisterColorHandlersEvent.Item event) {
            for (RegisteredBlock registeredBlock : RAINBOW_BLOCKS) {
                event.register((stack, index) -> RAINBOW_COLOR.color(), new ItemLike[]{registeredBlock.m_5456_()});
            }
            for (RegisteredBlock registeredBlock : GRASS_COLORED_BLOCKS) {
                event.register((stack, index) -> GrassColor.m_46415_((double)0.5, (double)1.0), new ItemLike[]{registeredBlock.m_5456_()});
            }
            for (Map.Entry entry : COLORED_BLOCKS.entries()) {
                Integer color = (Integer)entry.getKey();
                RegisteredBlock block = (RegisteredBlock)entry.getValue();
                event.register((stack, index) -> color, new ItemLike[]{block.get()});
            }
            for (Map.Entry entry : PMFluids.COLORED_BUCKETS.entrySet()) {
                ForgeFlowingFluid fluid = (ForgeFlowingFluid)((RegistryObject)entry.getKey()).get();
                Item bucket = (Item)((Supplier)entry.getValue()).get();
                ResourceKey bucketKey = (ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)bucket).get();
                event.register((stack, index) -> {
                    if (bucketKey == PMFluids.PSYCHEDELIC_LAVA_BUCKET.getKey() || bucketKey == PMFluids.PSYCHEDELIC_FLUID_BUCKET.getKey()) {
                        return index == 1 ? RAINBOW_COLOR.color() : -1;
                    }
                    int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
                    return index == 1 ? color : -1;
                }, new ItemLike[]{bucket});
            }
        }

        public static void colorBlocks(RegisterColorHandlersEvent.Block event) {
            for (RegisteredBlock block : RAINBOW_BLOCKS) {
                event.register((state, reader, pos, color) -> RAINBOW_COLOR.color(), new Block[]{block.get()});
            }
            for (RegisteredBlock block : GRASS_COLORED_BLOCKS) {
                event.register((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{block.get()});
            }
            for (Map.Entry entry : COLORED_BLOCKS.entries()) {
                Integer blockColor = (Integer)entry.getKey();
                RegisteredBlock block = (RegisteredBlock)entry.getValue();
                event.register((state, reader, pos, color) -> blockColor, new Block[]{block.get()});
            }
            for (RegisteredBlock block : PMFluids.COLORED_CAULDRONS) {
                CustomCauldron cauldron = (CustomCauldron)block.get();
                event.register((state, reader, pos, color) -> cauldron.fluidTintColor(), new Block[]{cauldron});
            }
            event.register((state, reader, pos, color) -> RedStoneWireBlock.m_55606_((int)((Integer)state.m_61143_((Property)RedstoneWire.POWER))), new Block[]{Redstone.REDSTONE_WIRE.get()});
        }
    }

    public static class Common {
        @SubscribeEvent
        public static void addFurnaceFuels(FurnaceFuelBurnTimeEvent event) {
            Item item = event.getItemStack().m_41720_();
            if (item == Misc.ASPHALT_SHARD.get()) {
                event.setBurnTime(3200);
            } else if (item == Building.ASPHALT.get().m_5456_()) {
                event.setBurnTime(32000);
            } else if (item == PMFluids.TAR_BUCKET.get()) {
                event.setBurnTime(3200);
            } else if (item == PMFluids.DARK_LAVA_BUCKET.get()) {
                event.setBurnTime(20000);
            } else if (item == PMFluids.MOLTEN_SALT_BUCKET.get()) {
                event.setBurnTime(20000);
            } else if (item == PMFluids.PSYCHEDELIC_LAVA_BUCKET.get()) {
                event.setBurnTime(20000);
            } else if (item == PMFluids.LIQUID_REDSTONE_BUCKET.get()) {
                event.setBurnTime(20000);
            }
        }

        @SubscribeEvent
        public static void unlockAllRecipes(PlayerEvent.PlayerLoggedInEvent event) {
            if (!ModList.get().isLoaded("quark")) {
                Player perro = event.getEntity();
                MinecraftServer server = perro.m_20194_();
                Collection recipes = server.m_129894_().m_44051_();
                perro.m_7281_(recipes);
                ParadiseMod.LOG.info("Unlocked " + recipes.size() + " recipes for " + perro.m_5446_().getString());
            }
        }

        public static void populateCreativeTabs(BuildCreativeModeTabContentsEvent event) {
            ParadiseMod.LOG.debug("Populating creative tabs...");
            ResourceKey curTab = event.getTabKey();
            for (RegisteredBlock block : RegisteredBlock.ALL_BLOCKS) {
                if (!block.hasTab((ResourceKey<CreativeModeTab>)curTab)) continue;
                event.m_246326_((ItemLike)block.m_5456_());
            }
            for (RegisteredItem item : RegisteredItem.ALL_ITEMS) {
                if (!item.hasTab((ResourceKey<CreativeModeTab>)curTab)) continue;
                event.m_246326_((ItemLike)item.m_5456_());
            }
            for (Map.Entry entry : Utils.CREATIVE_TAB_ITEMS.entries()) {
                ResourceKey tab = (ResourceKey)entry.getKey();
                Item item = (Item)entry.getValue();
                if (tab != curTab) continue;
                event.m_246326_((ItemLike)item);
            }
        }
    }
}

