/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class RainbowColor {
    private static int RED = 0xFF0000;
    public static List<Integer> RAINBOW_COLORS = List.of(RED, 16004421, 16419073, 16439063, 47729, 65280, 49886, 255, 16781, 6236281, RED);
    private final ArrayList<Integer> gradient = new ArrayList();
    private int colorIndex = 0;
    private Instant time = Instant.now();

    public RainbowColor() {
        for (int idx = 0; idx < RAINBOW_COLORS.size() - 1; ++idx) {
            Integer firstColor = RAINBOW_COLORS.get(idx);
            Integer secondColor = RAINBOW_COLORS.get(idx + 1);
            this.gradient.add(firstColor);
            for (int numerator = 1; numerator < 20; ++numerator) {
                this.gradient.add(RainbowColor.mixColors(firstColor, secondColor, (float)numerator / 20.0f));
            }
            this.gradient.add(secondColor);
        }
    }

    public int color() {
        Integer color = this.gradient.get(this.colorIndex);
        this.incIndex();
        return color;
    }

    private void incIndex() {
        Instant now = Instant.now();
        if (now.toEpochMilli() - this.time.toEpochMilli() >= 100L) {
            this.time = now;
            this.colorIndex = this.colorIndex < this.gradient.size() - 1 ? ++this.colorIndex : 0;
        }
    }

    private static int mixColors(int firstColor, int secondColor, float ratio) {
        int mask1 = 0xFF00FF;
        int mask2 = -16711936;
        int f2 = (int)(256.0f * ratio);
        int f1 = 256 - f2;
        return (firstColor & mask1) * f1 + (secondColor & mask1) * f2 >> 8 & mask1 | (firstColor & mask2) * f1 + (secondColor & mask2) * f2 >> 8 & mask2;
    }
}

