/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.world.DeepDarkBlocks;

public class CustomPlant
extends BushBlock
implements ModeledBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private final boolean large;
    private final Type type;

    public CustomPlant(boolean isLarge, boolean replaceable, Type type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)(replaceable ? Blocks.f_50034_ : Blocks.f_50112_)).m_60918_(SoundType.f_56740_).m_60910_());
        this.type = type;
        this.large = isLarge;
    }

    public CustomPlant(boolean isLarge, Type type, int light) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_).m_60918_(SoundType.f_56740_).m_60910_().m_60953_(s -> light));
        this.type = type;
        this.large = isLarge;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.large) {
            return Shapes.m_83144_();
        }
        return SHAPE;
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        if (super.m_6266_(state, world, pos)) {
            return true;
        }
        switch (this.type) {
            case DEEP_DARK: {
                return state.m_60713_(DeepDarkBlocks.DARKSTONE.get()) || state.m_60713_(DeepDarkBlocks.GLOWING_NYLIUM.get()) || state.m_60713_(DeepDarkBlocks.OVERGROWN_DARKSTONE.get());
            }
            case END: {
                return state.m_204336_(Tags.Blocks.END_STONES);
            }
        }
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_60713_((Block)this)) {
            if (super.m_7898_(state, world, pos)) {
                return true;
            }
            switch (this.type) {
                case DEEP_DARK: {
                    return state.m_60713_(DeepDarkBlocks.DARKSTONE.get()) || state.m_60713_(DeepDarkBlocks.GLOWING_NYLIUM.get()) || state.m_60713_(DeepDarkBlocks.OVERGROWN_DARKSTONE.get());
                }
                case END: {
                    return state.m_204336_(Tags.Blocks.END_STONES);
                }
            }
            return false;
        }
        return this.m_6266_(world.m_8055_(pos), (BlockGetter)world, pos);
    }

    @Override
    public void genBlockState(BlockStateGenerator generator) {
        generator.genSimplePlant((Block)this);
    }

    public static enum Type {
        NORMAL,
        END,
        DEEP_DARK;

    }
}

