/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.paradisemod.base.data.PMAdvancements;
import net.paradisemod.base.data.PMRegistrySetBuilder;
import net.paradisemod.base.data.RecipeGenerator;
import net.paradisemod.base.data.assets.AtlasGenerator;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.data.loot.PMLootTables;
import net.paradisemod.base.data.tags.PMBannerTags;
import net.paradisemod.base.data.tags.PMBiomeTags;
import net.paradisemod.base.data.tags.PMBlockTags;
import net.paradisemod.base.data.tags.PMEntityTags;
import net.paradisemod.base.data.tags.PMFluidTags;
import net.paradisemod.base.data.tags.PMItemTags;
import net.paradisemod.base.data.tags.PMPaintingTags;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.worldgen.PMBiomeModifier;
import net.paradisemod.worldgen.carver.PMCarvers;
import net.paradisemod.worldgen.features.PMFeatures;
import net.paradisemod.worldgen.structures.PMStructures;

public class DataGen {
    private static final PMRegistrySetBuilder WORLDGEN_DATA = new PMRegistrySetBuilder().add(Registries.f_256952_, PMBiomes.BIOMES).add(Registries.f_257003_, PMCarvers.CFG_CARVERS).add(Registries.f_256911_, PMFeatures.CFG_FEATURES).add(Registries.f_256988_, PMFeatures.PLACED_FEATURES).add(Registries.f_256944_, PMStructures.STRUCTURES).add(Registries.f_256948_, PMStructures::buildStructPools).add(Registries.f_256998_, PMStructures::buildStructSets).add(Registries.f_256787_, PMDimensions::buildDimensionTypes).add(Registries.f_256862_, PMDimensions::buildDimensions).add(ForgeRegistries.Keys.BIOME_MODIFIERS, PMBiomeModifier::buildBiomeModifier);

    public static void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture blankLookup = event.getLookupProvider();
        DatapackBuiltinEntriesProvider dataRegistries = new DatapackBuiltinEntriesProvider(output, blankLookup, (RegistrySetBuilder)WORLDGEN_DATA, Set.of("paradisemod"));
        CompletableFuture registryProvider = dataRegistries.getRegistryProvider();
        generator.addProvider(true, (DataProvider)dataRegistries);
        generator.addProvider(true, (DataProvider)new PMLootTables(output));
        generator.addProvider(true, (DataProvider)new RecipeGenerator(output));
        generator.addProvider(true, (DataProvider)new PMAdvancements(output, registryProvider, fileHelper));
        PMBlockTags blockTags = new PMBlockTags(output, registryProvider, fileHelper);
        generator.addProvider(true, (DataProvider)blockTags);
        generator.addProvider(true, (DataProvider)new PMItemTags(output, registryProvider, blockTags.m_274426_(), fileHelper));
        generator.addProvider(true, (DataProvider)new PMBiomeTags(output, registryProvider, fileHelper));
        generator.addProvider(true, (DataProvider)new PMFluidTags(output, registryProvider, fileHelper));
        generator.addProvider(true, (DataProvider)new PMBannerTags(output, registryProvider, fileHelper));
        generator.addProvider(true, (DataProvider)new PMPaintingTags(output, registryProvider, fileHelper));
        generator.addProvider(true, (DataProvider)new PMEntityTags(output, registryProvider, fileHelper));
        ItemModelGenerator itemModelGenerator = new ItemModelGenerator(output, fileHelper);
        generator.addProvider(true, (DataProvider)new AtlasGenerator(output, fileHelper));
        generator.addProvider(true, (DataProvider)new BlockStateGenerator(output, fileHelper, itemModelGenerator));
        generator.addProvider(true, (DataProvider)itemModelGenerator);
        generator.addProvider(true, (DataProvider)new PMTranslations(output, true));
        generator.addProvider(true, (DataProvider)new PMTranslations(output, false));
    }
}

