/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.building.Building;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.misc.Tools;
import net.paradisemod.world.DeepDarkBlocks;
import net.paradisemod.world.PMWorld;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.dimension.PMDimensions;

public class PMAdvancements
extends ForgeAdvancementProvider {
    public PMAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(PMAdvancements::buildAdvancements));
    }

    public static void translations(PMTranslations translator, boolean spanish) {
        translator.add(PMAdvancements.advancementDescKey("root"), spanish ? "Minecraft puede ser lo que quieres" : "Minecraft can be whatever you want it to be!");
        translator.add(PMAdvancements.advancementKey("going_even_deeper"), spanish ? "\u00a1Necesitamos viajar a\u00fan m\u00e1s profundo!" : "We need to go even deeper!");
        translator.add(PMAdvancements.advancementDescKey("going_even_deeper"), spanish ? "Viajar al Centro del sobremundo" : "Travel to the Overworld Core");
        translator.add(PMAdvancements.advancementKey("deep_dark"), spanish ? "La dimensi\u00f3n de oscuridad total" : "The Pitch Black Dimension");
        translator.add(PMAdvancements.advancementDescKey("deep_dark"), spanish ? "Viajar al Oscuro profundo" : "Travel to the Deep Dark");
        translator.add(PMAdvancements.advancementKey("elysium"), spanish ? "El sue\u00f1o de Notch" : "Notch's Dream");
        translator.add(PMAdvancements.advancementDescKey("elysium"), spanish ? "Viajar a El\u00edseo" : "Travel to Elysium");
        translator.add(PMAdvancements.advancementKey("regen_stone"), spanish ? "\u00a1Soy inmortal!" : "I'm immortal!!");
        translator.add(PMAdvancements.advancementDescKey("regen_stone"), spanish ? "Minar una piedra de regeneraci\u00f3n" : "Mine a Regeneration Stone");
        translator.add(PMAdvancements.advancementKey("killer_rabbit"), spanish ? "\u00bfEs la bestia? \u00a1Solamente es un conejo!" : "That's the beast? 'Tis but a rabbit!");
        translator.add(PMAdvancements.advancementDescKey("killer_rabbit"), spanish ? "Matar un conejo mortal" : "Kill a Killer Bunny");
        translator.add(PMAdvancements.advancementKey("spawn_giant"), spanish ? "\u00a1Ay caramba! \u00a1\u00bfQu\u00e9 es \u00e9so?!" : "WHAT THE HECK IS THAT?!");
        translator.add(PMAdvancements.advancementDescKey("spawn_giant"), spanish ? "Generar un gigante" : "Summon a Giant");
        translator.add(PMAdvancements.advancementKey("rose_field"), spanish ? "\u00bfPor qu\u00e9 no pueden flores gustar a un hombre?" : "Why can't a dude like flowers?");
        translator.add(PMAdvancements.advancementDescKey("rose_field"), spanish ? "Encontar un campo de rosas" : "Find a Rose Field biome");
        translator.add(PMAdvancements.advancementKey("seasons"), spanish ? "Cuando las estaciones se cambian" : "When the Seasons Change");
        translator.add(PMAdvancements.advancementDescKey("seasons"), spanish ? "Encontrar el bioma de bosque de oto\u00f1o" : "Find The Autumn Forest biome");
        translator.add(PMAdvancements.advancementKey("arizona"), spanish ? "\u00a1Bienvenidos a Arizona!" : "Welcome to Arizona!");
        translator.add(PMAdvancements.advancementDescKey("arizona"), spanish ? "Encontrar un bioma de desierto rocoso" : "Find a Rocky Desert biome");
        translator.add(PMAdvancements.advancementKey("rusted_weapon"), spanish ? "Un ataque oxidado" : "A Rusted Attack");
        translator.add(PMAdvancements.advancementDescKey("rusted_weapon"), spanish ? "Construir una espada de hierro oxidado" : "Craft a Rusted Iron Sword");
        translator.add(PMAdvancements.advancementKey("redstone_sword"), spanish ? "Una espada de fuego" : "A Fiery Sword");
        translator.add(PMAdvancements.advancementDescKey("redstone_sword"), spanish ? "Construir una espada de piedra roja" : "Craft a Redstone Sword");
        translator.add(PMAdvancements.advancementKey("the_origin"), spanish ? "El principio de tiempo" : "The Beginning of Time");
        translator.add(PMAdvancements.advancementDescKey("the_origin"), spanish ? "Encontrar el bioma del origen" : "Find The Origin biome");
        translator.add(PMAdvancements.advancementKey("prison_breakout"), spanish ? "La fuga de c\u00e1rcel" : "Prison Breakout");
        translator.add(PMAdvancements.advancementDescKey("prison_breakout"), spanish ? "Matar el monstruo de warden" : "Kill the Warden");
    }

    private static void buildAdvancements(HolderLookup.Provider registries, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)Building.RED_GLOWING_OBSIDIAN, (Component)Component.m_237115_((String)"paradisemod.name"), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("root")), new ResourceLocation("paradisemod:textures/block/blaze_block.png"), FrameType.TASK, false, false, false).m_138386_("changed_dimension", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_147560_((ResourceKey)Level.f_46428_, PMDimensions.Type.OVERWORLD_CORE.getKey())).m_138389_(saver, "paradisemod:paradisemod/root");
        Advancement goingEvenDeeper = Advancement.Builder.m_138353_().m_138371_((ItemLike)PMWorld.OVERWORLD_CORE_PORTAL, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("going_even_deeper")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("going_even_deeper")), null, FrameType.TASK, true, true, false).m_138386_("changed_dimension", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(PMDimensions.Type.OVERWORLD_CORE.getKey())).m_138398_(root).m_138389_(saver, "paradisemod:paradisemod/going_even_deeper");
        Advancement deepDark = Advancement.Builder.m_138353_().m_138371_((ItemLike)DeepDarkBlocks.DARKSTONE, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("deep_dark")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("deep_dark")), null, FrameType.TASK, true, true, false).m_138386_("changed_dimension", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(PMDimensions.Type.DEEP_DARK.getKey())).m_138398_(goingEvenDeeper).m_138389_(saver, "paradisemod:paradisemod/deep_dark");
        Advancement.Builder.m_138353_().m_138371_((ItemLike)PMWorld.ELYSIUM_PORTAL, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("elysium")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("elysium")), null, FrameType.TASK, true, true, false).m_138386_("changed_dimension", (CriterionTriggerInstance)ChangeDimensionTrigger.TriggerInstance.m_19782_(PMDimensions.Type.ELYSIUM.getKey())).m_138398_(deepDark).m_138389_(saver, "paradisemod:paradisemod/elysium");
        Advancement.Builder.m_138353_().m_138371_((ItemLike)DeepDarkBlocks.REGENERATION_STONE, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("regen_stone")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("regen_stone")), null, FrameType.TASK, true, true, false).m_138386_("regen_stone", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DeepDarkBlocks.REGENERATION_STONE})).m_138398_(deepDark).m_138389_(saver, "paradisemod:paradisemod/regen_stone");
        CompoundTag rabbitTag = new CompoundTag();
        rabbitTag.m_128405_("RabbitType", 99);
        Advancement killerRabbit = Advancement.Builder.m_138353_().m_138371_((ItemLike)PMWorld.ELYSIUM_PORTAL, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("killer_rabbit")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("killer_rabbit")), null, FrameType.CHALLENGE, true, true, false).m_138386_("kill_rabbit", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20517_).m_36654_(new NbtPredicate(rabbitTag)))).m_138398_(root).m_138389_(saver, "paradisemod:paradisemod/killer_rabbit");
        Advancement spawnGiant = Advancement.Builder.m_138353_().m_138371_((ItemLike)Blocks.f_50314_, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("spawn_giant")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("spawn_giant")), null, FrameType.CHALLENGE, true, true, false).m_138386_("summon_giant", (CriterionTriggerInstance)SummonedEntityTrigger.TriggerInstance.m_68275_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20454_))).m_138398_(killerRabbit).m_138389_(saver, "paradisemod:paradisemod/spawn_giant");
        Advancement.Builder.m_138353_().m_138371_((ItemLike)Blocks.f_50183_, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("prison_breakout")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("prison_breakout")), null, FrameType.CHALLENGE, true, true, false).m_138386_("kill_warden", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217015_))).m_138398_(spawnGiant).m_138389_(saver, "paradisemod:paradisemod/prison_breakout");
        Advancement roseFields = PMAdvancements.createRoseFieldAdvancement(root, saver);
        Advancement theOrigin = Advancement.Builder.m_138353_().m_138371_((ItemLike)Blocks.f_50440_, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("the_origin")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("the_origin")), null, FrameType.TASK, true, true, false).m_138386_("the_origin", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.THE_ORIGIN))).m_138398_(roseFields).m_138389_(saver, "paradisemod:paradisemod/the_origin");
        Advancement seasons = Advancement.Builder.m_138353_().m_138371_((ItemLike)Decoration.ORANGE_AUTUMN_SAPLING, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("seasons")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("seasons")), null, FrameType.TASK, true, true, false).m_138386_("autumn_forest", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.AUTUMN_FOREST))).m_138398_(theOrigin).m_138389_(saver, "paradisemod:paradisemod/seasons");
        Advancement.Builder.m_138353_().m_138371_((ItemLike)Blocks.f_50128_, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("arizona")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("arizona")), null, FrameType.TASK, true, true, false).m_138386_("regular", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.ROCKY_DESERT))).m_138386_("high", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.HIGH_ROCKY_DESERT))).m_138386_("snowy", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.SNOWY_ROCKY_DESERT))).m_138386_("palo_verde", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.PALO_VERDE_FOREST))).m_138386_("mesquite", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(PMBiomes.MESQUITE_FOREST))).m_138360_(RequirementsStrategy.f_15979_).m_138398_(seasons).m_138389_(saver, "paradisemod:paradisemod/arizona");
        Advancement rustedWeapon = Advancement.Builder.m_138353_().m_138371_((ItemLike)Tools.RUSTED_IRON_SWORD, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("rusted_weapon")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("rusted_weapon")), null, FrameType.TASK, true, true, false).m_138386_("rusted_sword", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Tools.RUSTED_IRON_SWORD})).m_138398_(root).m_138389_(saver, "paradisemod:paradisemod/rusted_weapon");
        Advancement.Builder.m_138353_().m_138371_((ItemLike)Tools.REDSTONE_SWORD, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("redstone_sword")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("redstone_sword")), null, FrameType.TASK, true, true, false).m_138386_("redstone_sword", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Tools.REDSTONE_SWORD})).m_138398_(rustedWeapon).m_138389_(saver, "paradisemod:paradisemod/redstone_sword");
    }

    private static Advancement createRoseFieldAdvancement(Advancement root, Consumer<Advancement> saver) {
        Advancement.Builder roseFields = Advancement.Builder.m_138353_().m_138371_((ItemLike)Decoration.RED_ROSE, (Component)Component.m_237115_((String)PMAdvancements.advancementKey("rose_field")), (Component)Component.m_237115_((String)PMAdvancements.advancementDescKey("rose_field")), null, FrameType.TASK, true, true, false);
        ArrayList<String> roseFileReqs = new ArrayList<String>();
        for (Map.Entry<DyeColor, ResourceKey<Biome>> entry : PMBiomes.ROSE_FIELDS_BY_COLOR.entrySet()) {
            ResourceKey<Biome> roseField = entry.getValue();
            String colorName = entry.getKey().m_41065_();
            roseFileReqs.add(colorName);
            roseFields = roseFields.m_138386_(colorName, (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(roseField)));
        }
        return roseFields.m_138398_(root).m_138360_(RequirementsStrategy.f_15979_).m_138389_(saver, "paradisemod:paradisemod/rose_field");
    }

    private static String advancementKey(String name) {
        return "advancement.paradisemod.self." + name;
    }

    private static String advancementDescKey(String name) {
        return "advancement.paradisemod.self." + name + ".desc";
    }
}

