/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.data.tags.PMTags;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.building.Building;
import net.paradisemod.decoration.Decoration;
import net.paradisemod.misc.Armor;
import net.paradisemod.misc.Misc;
import net.paradisemod.misc.Tools;
import net.paradisemod.world.Ores;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> output) {
        int numblocks = 0;
        for (RegisteredBlock block : RegisteredBlock.ALL_BLOCKS) {
            if (block.hasRecipes()) {
                ++numblocks;
            }
            try {
                block.genRecipes(this, output);
            }
            catch (Exception exception) {
                ParadiseMod.LOG.error("Error generating recipes for " + block.shortName() + ": " + exception.getMessage());
                ParadiseMod.LOG.error("Stack trace:", (Throwable)exception);
            }
        }
        ParadiseMod.LOG.debug("Finished generating recipes for " + numblocks + " blocks");
        int numitems = 0;
        for (RegisteredItem registeredItem : RegisteredItem.ALL_ITEMS) {
            if (registeredItem.hasRecipes()) {
                ++numitems;
            }
            try {
                registeredItem.genRecipes(this, output);
            }
            catch (Exception e) {
                ParadiseMod.LOG.error("Error generating recipes for " + registeredItem.shortName() + ": " + e.getMessage());
                ParadiseMod.LOG.error("Stack trace:", (Throwable)e);
            }
        }
        ParadiseMod.LOG.debug("Finished generating recipes for " + numitems + " items");
        for (Map.Entry entry : Decoration.ROSES.entrySet()) {
            DyeColor color = (DyeColor)entry.getKey();
            RegisteredBlock rose = (RegisteredBlock)entry.getValue();
            this.shapelessRecipe(RecipeCategory.MISC, (ItemLike)ParadiseMod.DYES_BY_COLOR.get(color), rose).m_176500_(output, "paradisemod:" + color.m_41065_() + "_dye_from_rose");
        }
        this.shapelessRecipe(RecipeCategory.DECORATIONS, (ItemLike)Items.f_42588_, 9, new ItemLike[]{Blocks.f_50451_}).m_176500_(output, "paradisemod:nether_wart_from_nether_wart_block");
        this.shapelessRecipe(RecipeCategory.DECORATIONS, (ItemLike)Items.f_42692_, 4, new ItemLike[]{Blocks.f_50333_}).m_176500_(output, "paradisemod:quartz_from_quartz_block");
        this.getShapedBuilder(RecipeCategory.MISC, (ItemLike)Items.f_42437_).m_126130_("GGG").m_126130_("GAG").m_126130_("GGG").m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50074_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42410_).m_176500_(output, "paradisemod:notch_apple");
        this.getShapedBuilder(RecipeCategory.MISC, (ItemLike)Blocks.f_50091_).m_126130_("pp").m_126130_("pp").m_126127_(Character.valueOf('p'), (ItemLike)Blocks.f_50705_).m_176498_(output);
        this.getShapedBuilder(RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50443_).m_126130_("ss").m_126130_("ss").m_126127_(Character.valueOf('s'), (ItemLike)Building.POLISHED_END_STONE).m_176498_(output);
        this.stonecutterRecipe(Building.POLISHED_END_STONE, (ItemLike)Blocks.f_50443_).m_176500_(output, "paradisemod:stonecutter/end_stone_bricks");
        this.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50164_).m_126130_("s").m_126130_("S").m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50652_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42398_).m_176498_(output);
        this.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50166_, 3).m_126130_("##").m_126130_("##").m_126130_("##").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_126145_("metal_doors").m_176498_(output);
        this.getShapedBuilder(RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50376_).m_126130_("##").m_126130_("##").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_126145_("metal_trapdoors").m_176498_(output);
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(PMTags.Items.SILVER_RECYCLABLES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Misc.SILVER_NUGGET, (float)0.1f, (int)200).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_176500_(output, "paradisemod:smelting/silver_nugget_from_silver");
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(PMTags.Items.SILVER_RECYCLABLES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Misc.SILVER_NUGGET, (float)0.1f, (int)100).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_176500_(output, "paradisemod:blasting/silver_nugget_from_silver");
        this.furnaceRecipe(Building.GOLD_GLOWING_OBSIDIAN, (ItemLike)Blocks.f_50074_, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/gold_from_glowing_obsidian");
        this.furnaceRecipe(Building.SILVER_GLOWING_OBSIDIAN, (ItemLike)Ores.SILVER_BLOCK.get(), RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/silver_from_glowing_obsidian");
        this.furnaceRecipe(Building.IRON_GLOWING_OBSIDIAN, (ItemLike)Blocks.f_50075_, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/iron_from_glowing_obsidian");
        this.furnaceRecipe(Building.COPPER_GLOWING_OBSIDIAN, (ItemLike)Blocks.f_152504_, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/copper_from_glowing_obsidian");
        this.furnaceRecipe(Ores.DARKSTONE_COAL_ORE, (ItemLike)Items.f_42413_, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/coal_from_darkstone");
        this.furnaceRecipe(Ores.DARKSTONE_IRON_ORE, (ItemLike)Items.f_42416_, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/iron_from_darkstone");
        this.furnaceRecipe(Ores.DARKSTONE_GOLD_ORE, (ItemLike)Items.f_42417_, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/gold_from_darkstone");
        this.furnaceRecipe(Ores.DARKSTONE_SILVER_ORE, Misc.SILVER_INGOT, RecipeCategory.MISC).m_176500_(output, "paradisemod:smelting/silver_from_darkstone");
        this.blastingRecipe(Ores.DARKSTONE_COAL_ORE, (ItemLike)Items.f_42413_, RecipeCategory.MISC).m_176500_(output, "paradisemod:blasting/coal_from_darkstone");
        this.blastingRecipe(Ores.DARKSTONE_IRON_ORE, (ItemLike)Items.f_42416_, RecipeCategory.MISC).m_176500_(output, "paradisemod:blasting/iron_from_darkstone");
        this.blastingRecipe(Ores.DARKSTONE_GOLD_ORE, (ItemLike)Items.f_42417_, RecipeCategory.MISC).m_176500_(output, "paradisemod:blasting/gold_from_darkstone");
        this.blastingRecipe(Ores.DARKSTONE_SILVER_ORE, Misc.SILVER_INGOT, RecipeCategory.MISC).m_176500_(output, "paradisemod:blasting/silver_from_darkstone");
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Tools.EMERALD_AXE, Tools.RUBY_AXE, Items.f_42396_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Tools.EMERALD_HOE, Tools.RUBY_HOE, Items.f_42397_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Tools.EMERALD_SHOVEL, Tools.RUBY_SHOVEL, Items.f_42394_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Tools.EMERALD_PICKAXE, Tools.RUBY_PICKAXE, Items.f_42395_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Tools.EMERALD_SWORD, Tools.RUBY_SWORD, Items.f_42393_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Armor.EMERALD_HELMET, Armor.RUBY_HELMET, Items.f_42480_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Armor.EMERALD_CHESTPLATE, Armor.RUBY_CHESTPLATE, Items.f_42481_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Armor.EMERALD_LEGGINGS, Armor.RUBY_LEGGINGS, Items.f_42482_);
        this.buildNetheriteFromEmeraldRubySmithingRecipe(output, Armor.EMERALD_BOOTS, Armor.RUBY_BOOTS, Items.f_42483_);
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return CompletableFuture.allOf(super.m_213708_(output), this.m_253240_(output, new ResourceLocation("paradisemod:recipes/root"), Advancement.Builder.m_285878_().m_138386_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())));
    }

    public ShapedRecipeBuilder getShapedBuilder(RecipeCategory category, ItemLike result, int count) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result, (int)count).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public ShapedRecipeBuilder getShapedBuilder(RecipeCategory category, ItemLike result) {
        return this.getShapedBuilder(category, result, 1);
    }

    public ShapedRecipeBuilder getShapedBuilder(RecipeCategory category, ItemLike result, String wholePattern) {
        ShapedRecipeBuilder builder = this.getShapedBuilder(category, result);
        for (String pattern : wholePattern.lines().toList()) {
            builder = builder.m_126130_(pattern);
        }
        return builder;
    }

    public ShapelessRecipeBuilder shapelessRecipe(RecipeCategory category, ItemLike result, int count, ItemLike ... inputItems) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result, (int)count);
        for (ItemLike item : inputItems) {
            builder = builder.m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return builder.m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public ShapelessRecipeBuilder shapelessRecipe(RecipeCategory category, ItemLike result, ItemLike ... inputItems) {
        return this.shapelessRecipe(category, result, 1, inputItems);
    }

    public SingleItemRecipeBuilder stonecutterRecipe(ItemLike input, ItemLike result, int count) {
        return SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public SingleItemRecipeBuilder stonecutterRecipe(ItemLike input, ItemLike result) {
        return this.stonecutterRecipe(input, result, 1);
    }

    public SimpleCookingRecipeBuilder campfireRecipe(ItemLike input, ItemLike result, RecipeCategory category, float exp, int cookTime) {
        return SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)result, (float)exp, (int)cookTime).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public SimpleCookingRecipeBuilder campfireRecipe(ItemLike input, ItemLike result, RecipeCategory category) {
        return this.campfireRecipe(input, result, category, 0.1f, 200);
    }

    public SimpleCookingRecipeBuilder blastingRecipe(ItemLike input, ItemLike result, RecipeCategory category, float exp, int cookTime) {
        return SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)result, (float)exp, (int)cookTime).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public SimpleCookingRecipeBuilder blastingRecipe(ItemLike inputItem, ItemLike resultItem, RecipeCategory category) {
        return this.blastingRecipe(inputItem, resultItem, category, 0.1f, 100);
    }

    public SimpleCookingRecipeBuilder smokingRecipe(ItemLike inputItem, ItemLike resultItem, RecipeCategory category, float exp, int cookTime) {
        return SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (ItemLike)resultItem, (float)exp, (int)cookTime).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public SimpleCookingRecipeBuilder smokingRecipe(ItemLike inputItem, ItemLike resultItem, RecipeCategory category) {
        return this.smokingRecipe(inputItem, resultItem, category, 0.1f, 200);
    }

    public SimpleCookingRecipeBuilder furnaceRecipe(ItemLike inputItem, ItemLike resultItem, RecipeCategory category, float exp, int cookTime) {
        return SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputItem}), (RecipeCategory)category, (ItemLike)resultItem, (float)exp, (int)cookTime).m_126132_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    public SimpleCookingRecipeBuilder furnaceRecipe(ItemLike inputItem, ItemLike resultItem, RecipeCategory category) {
        return this.furnaceRecipe(inputItem, resultItem, category, 0.1f, 200);
    }

    public SmithingTransformRecipeBuilder smithingRecipe(ItemLike base, ItemLike addition, ItemLike template, ItemLike result, RecipeCategory category) {
        return SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{template}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), (RecipeCategory)category, (Item)result.m_5456_()).m_266439_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
    }

    private void buildNetheriteFromEmeraldRubySmithingRecipe(Consumer<FinishedRecipe> output, ItemLike emeraldTool, ItemLike rubyTool, Item netheriteTool) {
        String name = ForgeRegistries.ITEMS.getKey((Object)netheriteTool.m_5456_()).m_135815_();
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{emeraldTool, rubyTool}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (RecipeCategory)(name.endsWith("sword") ? RecipeCategory.COMBAT : RecipeCategory.TOOLS), (Item)netheriteTool).m_266439_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_266260_(output, "paradisemod:smithing/" + name + "_from_emerald_and_ruby");
    }
}

