/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data.assets;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.world.blocks.SpreadableBlock;

public class BlockStateGenerator
extends BlockStateProvider {
    private final ItemModelGenerator itemModelGenerator;

    public BlockStateGenerator(PackOutput output, ExistingFileHelper fileHelper, ItemModelGenerator itemModelGenerator) {
        super(output, "paradisemod", fileHelper);
        this.itemModelGenerator = itemModelGenerator;
    }

    protected void registerStatesAndModels() {
        for (RegisteredBlock block : RegisteredBlock.ALL_BLOCKS) {
            try {
                block.genBlockState(this);
            }
            catch (Exception e) {
                ParadiseMod.LOG.error("Error generating block state definition for " + block.shortName() + ": " + e.getMessage());
                ParadiseMod.LOG.error("Stack trace:", (Throwable)e);
            }
        }
        ParadiseMod.LOG.debug("Finished generating block state definitions for " + RegisteredBlock.ALL_BLOCKS.size() + " blocks");
    }

    public ItemModelGenerator itemModels() {
        return this.itemModelGenerator;
    }

    public ModelFile.ExistingModelFile existingModel(String modelName) throws IllegalStateException {
        return this.existingModel(this.modLoc("block/" + modelName));
    }

    public ModelFile.ExistingModelFile existingMCModel(String modelName) {
        return this.existingModel(this.mcLoc("block/" + modelName));
    }

    public ModelFile.ExistingModelFile existingModel(ResourceLocation modelName) {
        ModelFile.ExistingModelFile file = new ModelFile.ExistingModelFile(modelName, this.models().existingFileHelper);
        try {
            file.assertExistence();
        }
        catch (Exception e) {
            throw new IllegalStateException("The model \"" + String.valueOf(modelName) + "\" doesn't seem to exist!");
        }
        return file;
    }

    public ModelFile.UncheckedModelFile uncheckedExistingModel(ResourceLocation modelName) {
        ParadiseMod.LOG.warn("Not checking for the existence of \"" + String.valueOf(modelName) + "\". Please verify it exists if it is being generated!");
        return new ModelFile.UncheckedModelFile(modelName);
    }

    public ModelFile.UncheckedModelFile uncheckedExistingModel(String modelName) {
        return this.uncheckedExistingModel(this.modLoc("block/" + modelName));
    }

    public ConfiguredModel[] buildVariantModel(ModelFile model, Direction facing, boolean fourWay) {
        int xRot = BlockStateGenerator.calcXRot(facing);
        if (fourWay) {
            xRot = 0;
        }
        int yRot = BlockStateGenerator.calcYRot(facing);
        return this.buildVariantModel(model, xRot, yRot);
    }

    public ConfiguredModel[] buildVariantModel(ModelFile model, Direction facing) {
        return this.buildVariantModel(model, facing, false);
    }

    public ConfiguredModel[] buildVariantModelFacingUp(ModelFile model, Direction facing) {
        int xRot = BlockStateGenerator.calcXRot(facing) + 90;
        int yRot = BlockStateGenerator.calcYRot(facing);
        return this.buildVariantModel(model, xRot, yRot);
    }

    public static int calcXRot(Direction facing) {
        return switch (facing) {
            case Direction.DOWN -> 90;
            case Direction.UP -> 270;
            default -> 0;
        };
    }

    public static int calcYRot(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> 90;
            case Direction.WEST -> 270;
            default -> 0;
            case Direction.SOUTH -> 180;
        };
    }

    public ConfiguredModel[] buildVariantModel(ModelFile model) {
        return this.buildVariantModel(model, Direction.NORTH, true);
    }

    public ConfiguredModel[] buildVariantModel(ModelFile model, int xRot, int yRot) {
        ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile(model);
        if (yRot > 0) {
            builder = builder.rotationY(yRot);
        }
        if (xRot > 0 && xRot < 360) {
            builder = builder.rotationX(xRot);
        }
        return builder.build();
    }

    public void genSimplePlant(Block block, String modelName) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("block/" + modelName, this.modLoc("block/" + modelName))).renderType("cutout");
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.itemModels().flatBlockItem(key.m_135815_(), modelName);
        this.simpleBlock(block, (ModelFile)model);
    }

    public void genSimplePlant(Block block) {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.genSimplePlant(block, key.m_135815_());
    }

    public void grassBlockLike(RegisteredBlock block, String bottomTexture, boolean isSnowy) {
        String name = block.shortName();
        if (isSnowy) {
            this.grassBlockLike(block, bottomTexture, "paradisemod:block/snowy_" + name + "_side");
        } else {
            BlockModelProvider modelBuilder = this.models();
            BlockModelBuilder model = (BlockModelBuilder)modelBuilder.cubeBottomTop(block.shortName(), this.modLoc("block/" + name + "_side"), new ResourceLocation(bottomTexture), this.modLoc("block/" + name + "_top"));
            this.simpleBlock(block, (ModelFile)model);
        }
    }

    public void grassBlockLike(RegisteredBlock block, String bottomTexture, String snowySideTexture) {
        String name = block.shortName();
        BlockModelProvider modelBuilder = this.models();
        BlockModelBuilder model = (BlockModelBuilder)modelBuilder.cubeBottomTop(block.shortName(), this.modLoc("block/" + name + "_side"), new ResourceLocation(bottomTexture), this.modLoc("block/" + name + "_top"));
        BlockModelBuilder snowy = (BlockModelBuilder)modelBuilder.cubeBottomTop("snowy_" + block.shortName(), new ResourceLocation(snowySideTexture), new ResourceLocation(bottomTexture), this.mcLoc("block/grass_block_top"));
        this.getVariantBuilder(block.get()).forAllStates(state -> {
            boolean isBlockSnowy = (Boolean)state.m_61143_((Property)SpreadableBlock.f_56637_);
            if (isBlockSnowy) {
                return this.buildVariantModel((ModelFile)snowy);
            }
            return this.buildVariantModel((ModelFile)model);
        });
    }

    public void simpleBlock(RegisteredBlock block, String modelName) {
        this.simpleBlock(block.get(), modelName);
    }

    public void simpleBlock(RegisteredBlock block, ModelFile model) {
        this.simpleBlock(block.get(), model);
    }

    public void simpleBlock(RegisteredBlock block) {
        this.simpleBlock(block.get());
    }

    public void simpleBlock(Block block, String modelName) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll("block/" + modelName, this.modLoc("block/" + modelName));
        this.simpleBlock(block, (ModelFile)model);
    }

    public void simpleBlock(Block block, ModelFile model) {
        this.getVariantBuilder(block).partialState().setModels(this.buildVariantModel(model));
    }

    public void simpleBlock(Block block) {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.simpleBlock(block, key.m_135815_());
    }

    public void simpleBlockWithRenderType(Block block, String renderType) {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.simpleBlockWithRenderType(block, key.m_135815_(), renderType);
    }

    public void simpleBlockWithRenderType(Block block, String modelName, String renderType) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cubeAll("block/" + modelName, this.modLoc("block/" + modelName))).renderType(renderType);
        this.simpleBlock(block, (ModelFile)model);
    }

    public void vanillaTintedLeaves(RegisteredBlock block, String vanillaLeavesName) {
        String blockName = block.shortName();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + blockName, "leaves")).texture("all", "minecraft:block/" + vanillaLeavesName + "_leaves")).renderType("cutout");
        this.simpleBlock(block, (ModelFile)model);
    }

    public void tintedGrass(RegisteredBlock block) {
        String blockName = block.shortName();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("block/" + blockName, new ResourceLocation("block/tinted_cross"), "cross", this.mcLoc("block/grass"))).renderType("cutout");
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("item/" + blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", this.mcLoc("block/grass"));
        this.simpleBlock(block, (ModelFile)model);
    }
}

