/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data.assets;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.Utils;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredItem;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "paradisemod", existingFileHelper);
    }

    protected void registerModels() {
        int blockItemCount = 0;
        for (RegisteredBlock block : RegisteredBlock.ALL_BLOCKS) {
            if (!block.hasItem()) continue;
            try {
                block.genItemModel(this);
            }
            catch (Exception e) {
                ParadiseMod.LOG.error("Error generating block item model for " + block.shortName() + ": " + e.getMessage());
                ParadiseMod.LOG.error("Stack trace:", (Throwable)e);
            }
            ++blockItemCount;
        }
        ParadiseMod.LOG.debug("Finished generating block item models for " + blockItemCount + " blocks");
        for (RegisteredItem item : RegisteredItem.ALL_ITEMS) {
            try {
                item.genModel(this);
            }
            catch (Exception e) {
                ParadiseMod.LOG.error("Error generating block item model for " + item.shortName() + ": " + e.getMessage());
                ParadiseMod.LOG.error("Stack trace:", (Throwable)e);
            }
        }
        ParadiseMod.LOG.debug("Finished generating item models for " + RegisteredItem.ALL_ITEMS.size() + " items");
    }

    public void flatBlockItem(RegisteredBlock block) {
        this.flatBlockItem(block.shortName());
    }

    public void flatBlockItem(String modelName) {
        this.flatBlockItem(modelName, modelName);
    }

    public void flatBlockItem(String modelName, String texturePath) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + modelName)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", this.modLoc("block/" + texturePath));
    }

    public void glassPaneItem(String modelName, String texturePath) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + modelName)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", this.modLoc("block/" + texturePath))).renderType("translucent");
    }

    public void parentBlockItem(RegisteredBlock block) {
        this.parentBlockItem(block.get());
    }

    public void parentBlockItem(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.parentBlockItem(block, location.m_135815_());
    }

    public void parentBlockItem(Block block, String modelName) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        ((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)this.uncheckedExistingModel("block/" + modelName));
    }

    public void parentBlockItem(RegisteredBlock block, String modelName) {
        this.parentBlockItem(block.get(), modelName);
    }

    public void basicItem(Item item, String texturePath) {
        this.basicItem(item, this.modLoc("item/" + texturePath));
    }

    public void basicItem(Item item, ResourceLocation texturePath) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)item);
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", texturePath);
    }

    public void basicItem(Item item, String texturePath, String renderType) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)item);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(location.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/generated"))).texture("layer0", this.modLoc("item/" + texturePath))).renderType(renderType);
    }

    public ModelFile.ExistingModelFile existingModel(String modelName) {
        ModelFile.ExistingModelFile file = new ModelFile.ExistingModelFile(this.modLoc(modelName), this.existingFileHelper);
        try {
            file.assertExistence();
        }
        catch (Exception e) {
            Utils.modError("The model \"paradisemod:" + modelName + "\" doesn't seem to exist!");
        }
        return file;
    }

    public ModelFile.UncheckedModelFile uncheckedExistingModel(ResourceLocation modelName) {
        ParadiseMod.LOG.warn("Not checking for the existence of \"" + String.valueOf(modelName) + "\". Please verify it exists if it is being generated!");
        return new ModelFile.UncheckedModelFile(modelName);
    }

    public ModelFile.UncheckedModelFile uncheckedExistingModel(String modelName) {
        return this.uncheckedExistingModel(this.modLoc(modelName));
    }
}

