/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data.assets;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMPaintings;
import net.paradisemod.base.data.PMAdvancements;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredCreativeTab;
import net.paradisemod.base.registry.RegisteredCreature;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.bonus.PMBannerPatterns;
import net.paradisemod.world.biome.PMBiomes;
import net.paradisemod.world.fluid.PMFluids;

public class PMTranslations
extends LanguageProvider {
    private static final EnumMap<DyeColor, String> ENGLISH_DYE_NAMES = new EnumMap(DyeColor.class);
    private static final EnumMap<DyeColor, String> SPANISH_DYE_NAMES = new EnumMap(DyeColor.class);
    private final boolean isSpanish;

    public PMTranslations(PackOutput output, boolean isSpanish) {
        super(output, "paradisemod", isSpanish ? "es_mx" : "en_us");
        this.isSpanish = isSpanish;
    }

    protected void addTranslations() {
        String name;
        String langName = this.isSpanish ? "spanish" : "english";
        int numblocks = 0;
        for (RegisteredBlock block : RegisteredBlock.ALL_BLOCKS) {
            String string = block.getLocalizedName(this.isSpanish);
            if (!string.isEmpty()) {
                this.add(block.get(), string);
                ++numblocks;
                continue;
            }
            ParadiseMod.LOG.warn("Block " + block.shortName() + " doesn't have a translation key in " + langName + "!");
        }
        ParadiseMod.LOG.debug("Created " + langName + " names for " + numblocks + " blocks");
        int numitems = 0;
        for (RegisteredItem registeredItem : RegisteredItem.ALL_ITEMS) {
            name = registeredItem.getLocalizedName(this.isSpanish);
            if (!name.isEmpty()) {
                this.add(registeredItem.get(), name);
                ++numitems;
                continue;
            }
            ParadiseMod.LOG.warn("Item " + registeredItem.shortName() + " doesn't have a translation key in " + langName + "!");
        }
        for (RegisteredCreativeTab registeredCreativeTab : RegisteredCreativeTab.ALL_TABS) {
            registeredCreativeTab.genLocalizedName(this, this.isSpanish);
        }
        for (RegisteredCreature registeredCreature : RegisteredCreature.ALL_MOBS) {
            registeredCreature.translations(this, this.isSpanish);
        }
        for (RegistryObject registryObject : PMFluids.FLUIDS.getEntries()) {
            name = registryObject.getId().m_135815_();
            if (name.startsWith("flowing_")) continue;
            String key = "fluid_type.paradisemod." + name;
            String dispName = PMFluids.fluidName((RegistryObject<? extends Fluid>)registryObject, this.isSpanish);
            this.add(key, dispName);
        }
        ParadiseMod.LOG.debug("Created " + langName + " names for " + numitems + " items");
        this.add(Blocks.f_50091_, this.isSpanish ? "Mesa de trabajo de roble" : "Oak Crafting Table");
        this.add(Blocks.f_50087_, this.isSpanish ? "Cofre de roble" : "Oak Chest");
        this.add(Blocks.f_50325_, this.isSpanish ? "Cofre de roble con trampa" : "Trapped Oak Chest");
        this.add(Blocks.f_50164_, this.isSpanish ? "Palanca de piedra labrada" : "Cobblestone Lever");
        this.add(Blocks.f_50326_, this.isSpanish ? "Placa de presi\u00f3n de oro (ligero)" : "Gold Pressure Plate (Light)");
        this.add(Blocks.f_50327_, this.isSpanish ? "Placa de presi\u00f3n de hierro (pesado)" : "Iron Pressure Plate (Heavy)");
        this.add(Blocks.f_50094_, this.isSpanish ? "Horno de piedra labrada" : "Cobblestone Furnace");
        this.add(Blocks.f_50332_, this.isSpanish ? "Tolva de hierro" : "Iron Hopper");
        this.add("paradisemod.name", this.isSpanish ? "Para\u00edso Mod" : "Paradise Mod");
        this.add("paradisemod.no_more_school", this.isSpanish ? "\u00a1Gracias a Dios he terminado escuela para siempre!" : "Thank God I'm done with school for good!");
        for (String string : PMPaintings.AUTHOR_KEYS) {
            this.add(string, "NetherNoah777");
        }
        for (Map.Entry entry : PMPaintings.PAINTING_NAMES.entrySet()) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.isSpanish) {
            this.add(Blocks.f_50259_, "Piedra del Fin");
            this.add(Blocks.f_50443_, "Ladrillos de piedra del Fin");
            this.add(Blocks.f_50634_, "Escaleras de ladrillos de piedra del Fin");
            this.add(Blocks.f_50648_, "Losa de ladrillos de piedra del Fin");
            this.add(Blocks.f_50330_, "Bloque de piedra roja");
            this.add(Blocks.f_50174_, "Antorcha de piedra roja");
            this.add(Items.f_42451_, "Polvo de piedra roja");
        }
        PMBannerPatterns.translations(this);
        PMBiomes.translations(this);
        PMAdvancements.translations(this, this.isSpanish);
    }

    public void addBanner(RegistryObject<BannerPattern> pattern, String englishName, String spanishName) {
        String patternName = pattern.getKey().m_135782_().m_135815_();
        String key = "item.paradisemod." + patternName + "_pattern.desc";
        this.add(key, this.isSpanish ? spanishName : englishName);
        for (DyeColor color : DyeColor.values()) {
            String colorKey = "block.minecraft.banner.paradisemod." + patternName + "." + color.m_41065_();
            if (this.isSpanish) {
                this.add(colorKey, spanishName + " " + PMTranslations.spanishColor(color, patternName == "david_star"));
                continue;
            }
            this.add(colorKey, PMTranslations.englishColor(color) + " " + englishName);
        }
    }

    public void addBiome(ResourceKey<Biome> biome, String englishName, String spanishName) {
        String key = "biome.paradisemod." + biome.m_135782_().m_135815_();
        this.add(key, this.isSpanish ? spanishName : englishName);
    }

    public void addEntity(RegistryObject<? extends EntityType<?>> entity, String englishName, String spanishName) {
        String name = entity.getKey().m_135782_().m_135815_();
        String key = "entity.paradisemod." + name;
        this.add(key, this.isSpanish ? spanishName : englishName);
    }

    public static String englishColor(DyeColor color) {
        return ENGLISH_DYE_NAMES.get(color);
    }

    public static String spanishColor(DyeColor color, boolean isFeminine) {
        String colorName = SPANISH_DYE_NAMES.get(color);
        if (isFeminine && color != DyeColor.LIGHT_BLUE && color != DyeColor.LIGHT_GRAY && colorName.endsWith("o")) {
            return colorName.substring(0, colorName.length() - 1) + "a";
        }
        return colorName;
    }

    static {
        ENGLISH_DYE_NAMES.put(DyeColor.WHITE, "White");
        ENGLISH_DYE_NAMES.put(DyeColor.ORANGE, "Orange");
        ENGLISH_DYE_NAMES.put(DyeColor.MAGENTA, "Magenta");
        ENGLISH_DYE_NAMES.put(DyeColor.LIGHT_BLUE, "Light Blue");
        ENGLISH_DYE_NAMES.put(DyeColor.YELLOW, "Yellow");
        ENGLISH_DYE_NAMES.put(DyeColor.LIME, "Lime");
        ENGLISH_DYE_NAMES.put(DyeColor.PINK, "Pink");
        ENGLISH_DYE_NAMES.put(DyeColor.GRAY, "Gray");
        ENGLISH_DYE_NAMES.put(DyeColor.LIGHT_GRAY, "Light Gray");
        ENGLISH_DYE_NAMES.put(DyeColor.CYAN, "Cyan");
        ENGLISH_DYE_NAMES.put(DyeColor.PURPLE, "Purple");
        ENGLISH_DYE_NAMES.put(DyeColor.BLUE, "Blue");
        ENGLISH_DYE_NAMES.put(DyeColor.BROWN, "Brown");
        ENGLISH_DYE_NAMES.put(DyeColor.GREEN, "Green");
        ENGLISH_DYE_NAMES.put(DyeColor.RED, "Red");
        ENGLISH_DYE_NAMES.put(DyeColor.BLACK, "Black");
        SPANISH_DYE_NAMES.put(DyeColor.WHITE, "blanco");
        SPANISH_DYE_NAMES.put(DyeColor.ORANGE, "naranja");
        SPANISH_DYE_NAMES.put(DyeColor.MAGENTA, "magenta");
        SPANISH_DYE_NAMES.put(DyeColor.LIGHT_BLUE, "azul claro");
        SPANISH_DYE_NAMES.put(DyeColor.YELLOW, "amarillo");
        SPANISH_DYE_NAMES.put(DyeColor.LIME, "verde lima");
        SPANISH_DYE_NAMES.put(DyeColor.PINK, "rosado");
        SPANISH_DYE_NAMES.put(DyeColor.GRAY, "gris");
        SPANISH_DYE_NAMES.put(DyeColor.LIGHT_GRAY, "gris claro");
        SPANISH_DYE_NAMES.put(DyeColor.CYAN, "cian");
        SPANISH_DYE_NAMES.put(DyeColor.PURPLE, "morado");
        SPANISH_DYE_NAMES.put(DyeColor.BLUE, "azul");
        SPANISH_DYE_NAMES.put(DyeColor.BROWN, "caf\u00e9");
        SPANISH_DYE_NAMES.put(DyeColor.GREEN, "verde");
        SPANISH_DYE_NAMES.put(DyeColor.RED, "rojo");
        SPANISH_DYE_NAMES.put(DyeColor.BLACK, "negro");
    }
}

