/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.data.loot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.misc.Misc;

public class BlockLootGenerator
extends BlockLootSubProvider {
    private final ArrayList<Block> blocks = new ArrayList();

    protected BlockLootGenerator() {
        super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
    }

    protected void m_245660_() {
        int numblocks = 0;
        for (RegisteredBlock block2 : RegisteredBlock.ALL_BLOCKS) {
            if (block2.hasLootTable()) {
                ++numblocks;
            }
            try {
                block2.genLootTable(this);
            }
            catch (Exception e) {
                ParadiseMod.LOG.error("Error generating block loot table for " + block2.shortName() + ": " + e.getMessage());
                ParadiseMod.LOG.error("Stack trace:", (Throwable)e);
            }
        }
        ParadiseMod.LOG.debug("Finished generating block loot tables for " + numblocks + " blocks");
        this.m_246481_(Blocks.f_50050_, block -> this.m_246047_((Block)block, Blocks.f_50746_, new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243905_.m_285888_(f_243678_).m_81807_()).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42410_))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243905_.m_285888_(f_243678_).m_81807_()).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Misc.ACORN))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))));
        this.m_246481_(Blocks.f_50055_, block -> this.m_246047_((Block)block, Blocks.f_50751_, new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243905_.m_285888_(f_243678_).m_81807_()).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42410_))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243905_.m_285888_(f_243678_).m_81807_()).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Misc.ACORN))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))));
        this.m_246481_(Blocks.f_271115_, block -> this.m_246047_((Block)block, Blocks.f_271334_, new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243905_.m_285888_(f_243678_).m_81807_()).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Misc.CHERRY))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f})))));
    }

    public void m_245724_(Block block) {
        this.m_246125_(block, (ItemLike)block);
    }

    public void m_245644_(Block block) {
        this.blocks.add(block);
        this.m_245854_(block, block);
    }

    public void m_246125_(Block block, ItemLike item) {
        this.blocks.add(block);
        this.m_247577_(block, this.m_247033_(item));
    }

    public void m_246535_(Block pot) {
        this.m_246481_(pot, block -> this.m_245602_((ItemLike)((FlowerPotBlock)block).m_53560_()));
    }

    public void leavesDrop(Block leaves, Block sapling) {
        this.m_246481_(leaves, block -> this.m_246047_((Block)block, sapling, f_244509_));
    }

    public void doorDrop(Block door) {
        this.m_246481_(door, block -> this.m_247398_((Block)block));
    }

    public void slabDrop(Block slab) {
        this.m_246481_(slab, block -> this.m_247233_((Block)block));
    }

    public void randomItemDrop(Block block, ItemLike item, int minDrops, int maxDrops) {
        this.m_246481_(block, blockIn -> BlockLootGenerator.m_247502_((Block)blockIn, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)blockIn, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minDrops, (float)maxDrops))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
    }

    public void multipleItemDrop(Block block, ItemLike item, int count) {
        this.m_246481_(block, blockIn -> BlockLootGenerator.m_247502_((Block)blockIn, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)blockIn, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
    }

    public void randomItemDrop(Block block, ItemLike item, int maxDrops) {
        this.randomItemDrop(block, item, 1, maxDrops);
    }

    public void dropUnlessSilkTouch(Block block, ItemLike drop) {
        this.m_246481_(block, blockIn -> this.m_245514_((Block)blockIn, drop));
    }

    public static LootItemCondition.Builder hasSilkTouch() {
        return f_243678_;
    }

    public <T extends FunctionUserBuilder<T>> T m_246108_(ItemLike item, FunctionUserBuilder<T> functionBuilder) {
        return (T)super.m_246108_(item, functionBuilder);
    }

    public void m_246481_(Block block, Function<Block, LootTable.Builder> factory) {
        this.blocks.add(block);
        super.m_246481_(block, factory);
    }

    protected ArrayList<Block> getKnownBlocks() {
        return this.blocks;
    }
}

