/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.mixin;

import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.PMConfig;
import net.paradisemod.base.mixin.NoiseBasedChunkGeneratorAccessor;
import net.paradisemod.base.mixin.NoiseGeneratorSettingsAccessor;
import net.paradisemod.world.dimension.PMDimensions;
import net.paradisemod.worldgen.surfacerules.PMSurfaceRules;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private LayeredRegistryAccess<RegistryLayer> f_244176_;

    @Inject(method={"createLevels"}, at={@At(value="HEAD")})
    private void hackyAddSurfaceRules(ChunkProgressListener chunkProgressListener, CallbackInfo ci) {
        Registry registry = this.f_244176_.m_247579_().m_175515_(Registries.f_256862_);
        if (((Boolean)PMConfig.SETTINGS.betterEnd.endFoliage.get()).booleanValue()) {
            MinecraftServerMixin.applySurfaceRule((Registry<LevelStem>)registry, (ResourceKey<LevelStem>)LevelStem.f_63973_, PMSurfaceRules.buildEndRule());
        }
        MinecraftServerMixin.applySurfaceRule((Registry<LevelStem>)registry, PMDimensions.Type.OVERWORLD_CORE.getLevelStemKey(), PMSurfaceRules.buildOverworldCoreRules());
        MinecraftServerMixin.applySurfaceRule((Registry<LevelStem>)registry, PMDimensions.Type.DEEP_DARK.getLevelStemKey(), PMSurfaceRules.buildDeepDarkRules());
        MinecraftServerMixin.applySurfaceRule((Registry<LevelStem>)registry, PMDimensions.Type.ELYSIUM.getLevelStemKey(), PMSurfaceRules.buildElysiumRules());
        ParadiseMod.LOG.debug("Custom surface rules applied to the End and custom dimensions");
    }

    private static void applySurfaceRule(Registry<LevelStem> dimRegistry, ResourceKey<LevelStem> dimKey, SurfaceRules.RuleSource rule) {
        LevelStem dim = (LevelStem)dimRegistry.m_6246_(dimKey);
        ChunkGenerator chunkGenerator = dim.f_63976_();
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noise = (NoiseGeneratorSettings)((NoiseBasedChunkGeneratorAccessor)noiseChunkGenerator).getSettings().m_203334_();
            ((NoiseGeneratorSettingsAccessor)noise).setSurfaceRule(rule);
        }
    }
}

