/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.ParadiseMod;
import net.paradisemod.base.Utils;
import net.paradisemod.base.registry.RegisteredBlock;
import net.paradisemod.base.registry.RegisteredCreature;
import net.paradisemod.base.registry.RegisteredItem;

public class PMRegistries {
    private static final DeferredRegister<Block> BLOCKS = PMRegistries.createRegistry(ForgeRegistries.BLOCKS);
    private static final DeferredRegister<Item> ITEMS = PMRegistries.createRegistry(ForgeRegistries.ITEMS);
    private static final DeferredRegister<BlockEntityType<?>> TILES = PMRegistries.createRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
    private static final DeferredRegister<EntityType<?>> ENTITIES = PMRegistries.createRegistry(ForgeRegistries.ENTITY_TYPES);
    private static final ArrayList<Consumer<EntityAttributeCreationEvent>> ENTITY_ATTRIBUTES = new ArrayList();

    public static RegisteredBlock regBlock(String name, Supplier<? extends Block> block) {
        return new RegisteredBlock((RegistryObject<Block>)Utils.handlePossibleException(() -> BLOCKS.register(name, block)), false);
    }

    public static RegisteredBlock regBlockItem(String name, Supplier<? extends Block> block) {
        RegisteredBlock regBlock = new RegisteredBlock((RegistryObject<Block>)BLOCKS.register(name, block), true);
        Utils.handlePossibleException(() -> ITEMS.register(name, () -> new BlockItem(regBlock.get(), new Item.Properties())));
        return regBlock;
    }

    public static RegisteredItem regItem(String name, Supplier<Item> item) {
        return new RegisteredItem((RegistryObject<Item>)Utils.handlePossibleException(() -> ITEMS.register(name, item)), false);
    }

    @SafeVarargs
    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> createTile(String name, BlockEntityType.BlockEntitySupplier<T> constructor, Supplier<Block> ... validBlocks) {
        return PMRegistries.createTile(name, constructor, List.of(validBlocks));
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> createTile(String name, BlockEntityType.BlockEntitySupplier<T> constructor, List<? extends Supplier<Block>> validBlocks) {
        return Utils.handlePossibleException(() -> TILES.register(name, () -> {
            Block[] blocks = (Block[])validBlocks.stream().map(Supplier::get).toArray(Block[]::new);
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)constructor, (Block[])blocks).m_58966_(null);
        }));
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> createEntity(String name, EntityType.Builder<T> builder) {
        return Utils.handlePossibleException(() -> ENTITIES.register(name, () -> builder.m_20712_("paradisemod:" + name)));
    }

    public static <C extends Mob> RegisteredCreature<C> createCreature(String name, EntityType.Builder<C> builder, Supplier<AttributeSupplier.Builder> attributesBuilder, String englishName, String spanishName) {
        RegistryObject regEntity = PMRegistries.createEntity(name, builder);
        ENTITY_ATTRIBUTES.add(event -> event.put((EntityType)regEntity.get(), ((AttributeSupplier.Builder)attributesBuilder.get()).m_22265_()));
        return new RegisteredCreature<C>(regEntity, englishName, spanishName);
    }

    public static void init(IEventBus eventbus) {
        BLOCKS.register(eventbus);
        ITEMS.register(eventbus);
        TILES.register(eventbus);
        ENTITIES.register(eventbus);
        eventbus.addListener(PMRegistries::genEntityAttributes);
        ParadiseMod.LOG.debug("Registration success!");
    }

    public static <R> DeferredRegister<R> createRegistry(IForgeRegistry<R> registry) {
        return DeferredRegister.create(registry, (String)"paradisemod");
    }

    public static <R> DeferredRegister<R> createRegistry(ResourceKey<? extends Registry<R>> key) {
        return DeferredRegister.create(key, (String)"paradisemod");
    }

    public static <T> ResourceKey<T> createModResourceKey(ResourceKey<? extends Registry<T>> registryKey, String name) {
        return PMRegistries.createResourceKey(registryKey, "paradisemod", name);
    }

    public static <T> ResourceKey<T> createResourceKey(ResourceKey<? extends Registry<T>> registryKey, String namespace, String name) {
        return ResourceKey.m_135785_(registryKey, (ResourceLocation)new ResourceLocation(namespace, name));
    }

    public static <T> ResourceKey<T> createResourceKey(ResourceKey<? extends Registry<T>> registryKey, String fullName) {
        return ResourceKey.m_135785_(registryKey, (ResourceLocation)new ResourceLocation(fullName));
    }

    private static void genEntityAttributes(EntityAttributeCreationEvent event) {
        for (Consumer<EntityAttributeCreationEvent> attrConsumer : ENTITY_ATTRIBUTES) {
            attrConsumer.accept(event);
        }
    }
}

