/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.registry;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.BlockStateGenerator;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.data.assets.ModeledBlock;
import net.paradisemod.base.data.loot.BlockLootGenerator;
import net.paradisemod.base.registry.RegisteredItem;
import net.paradisemod.base.registry.RegisteredObject;

public class RegisteredBlock
extends RegisteredObject<RegisteredBlock>
implements Supplier<Block> {
    public static final ArrayListMultimap<TagKey<Block>, RegisteredBlock> TAGGED_BLOCKS = ArrayListMultimap.create();
    public static final ArrayList<RegisteredBlock> ALL_BLOCKS = new ArrayList();
    private final RegistryObject<Block> block;
    private final boolean hasItem;
    private String renderType = "solid";
    @Nullable
    private BiConsumer<RegisteredBlock, ItemModelGenerator> itemModel;
    @Nullable
    private BiConsumer<RegisteredBlock, BlockStateGenerator> blockState;
    private BiConsumer<Block, BlockLootGenerator> lootTable = (block, generator) -> generator.m_245724_((Block)block);
    private boolean hasLootTable = true;

    protected RegisteredBlock(RegistryObject<Block> block2, boolean hasItem) {
        this.hasItem = hasItem;
        this.block = block2;
        ALL_BLOCKS.add(this);
    }

    public boolean hasLootTable() {
        return this.hasLootTable;
    }

    @Override
    public Block get() {
        return (Block)this.block.get();
    }

    public Item m_5456_() {
        if (this.hasItem) {
            return this.get().m_5456_();
        }
        return (Item)Utils.modErrorTyped(this.registeredName() + " doesn't have an item!");
    }

    public boolean hasItem() {
        return this.hasItem;
    }

    public RegisteredBlock tag(TagKey<Block> tag) {
        TAGGED_BLOCKS.put(tag, (Object)this);
        return this;
    }

    @SafeVarargs
    public final RegisteredBlock tags(TagKey<Block> ... tags) {
        return this.tags(List.of(tags));
    }

    public RegisteredBlock tags(List<TagKey<Block>> tags) {
        for (TagKey<Block> tag : tags) {
            TAGGED_BLOCKS.put(tag, (Object)this);
        }
        return this;
    }

    public RegisteredBlock itemTag(TagKey<Item> tag) {
        if (!this.hasItem) {
            return (RegisteredBlock)Utils.modErrorTyped(this.registeredName() + " doesn't have an item!");
        }
        RegisteredItem.TAGGED_ITEMS.put(tag, this::m_5456_);
        return this;
    }

    public RegisteredBlock itemTags(TagKey<Item> ... tags) {
        if (!this.hasItem) {
            return (RegisteredBlock)Utils.modErrorTyped(this.registeredName() + " doesn't have an item!");
        }
        for (TagKey<Item> tag : tags) {
            RegisteredItem.TAGGED_ITEMS.put(tag, this::m_5456_);
        }
        return this;
    }

    @Override
    public String registeredName() {
        return this.block.getKey().m_135782_().toString();
    }

    @Override
    public String shortName() {
        return this.block.getKey().m_135782_().m_135815_();
    }

    public RegisteredBlock itemModelAlreadyExists() {
        this.itemModel = (block, generator) -> {};
        return this;
    }

    public RegisteredBlock itemModel(BiConsumer<RegisteredBlock, ItemModelGenerator> model) {
        this.itemModel = model;
        return this;
    }

    public RegisteredBlock blockStateGenerator(BiConsumer<RegisteredBlock, BlockStateGenerator> blockState) {
        this.blockState = blockState;
        return this;
    }

    public RegisteredBlock renderType(String renderType) {
        this.renderType = renderType;
        return this;
    }

    public RegisteredBlock lootTable(BiConsumer<Block, BlockLootGenerator> lootTable) {
        this.lootTable = lootTable;
        return this;
    }

    public RegisteredBlock dropsWithSilkTouch() {
        this.lootTable = (block, generator) -> generator.m_245644_((Block)block);
        return this;
    }

    public RegisteredBlock noDrops() {
        this.hasLootTable = false;
        this.lootTable = (block, generator) -> {};
        return this;
    }

    public RegisteredBlock dropsItem(ItemLike item) {
        this.lootTable = (block, generator) -> generator.m_246125_((Block)block, item);
        return this;
    }

    public void genItemModel(ItemModelGenerator generator) {
        Block block = this.get();
        if (this.itemModel != null) {
            this.itemModel.accept(this, generator);
        } else if (block instanceof ModeledBlock) {
            ModeledBlock modeledBlock = (ModeledBlock)block;
            modeledBlock.genItemModel(generator);
        } else {
            generator.parentBlockItem(this);
        }
    }

    public void genBlockState(BlockStateGenerator generator) {
        Block block = this.get();
        if (this.blockState != null) {
            this.blockState.accept(this, generator);
        } else if (block instanceof ModeledBlock) {
            ModeledBlock modeledBlock = (ModeledBlock)block;
            modeledBlock.genBlockState(generator);
        } else if (this.renderType != "solid") {
            generator.simpleBlockWithRenderType(this.get(), this.renderType);
        } else {
            generator.simpleBlock(this);
        }
    }

    public void genLootTable(BlockLootGenerator generator) {
        this.lootTable.accept(this.get(), generator);
    }
}

