/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.registry;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredItem;

public class RegisteredCreature<C extends Mob>
implements Supplier<EntityType<C>> {
    public static final ArrayList<RegisteredCreature<?>> ALL_MOBS = new ArrayList();
    private final RegistryObject<EntityType<C>> mobType;
    private Optional<RegisteredItem> maybeSpawnEgg;
    private String englishName;
    private String spanishName;

    protected RegisteredCreature(RegistryObject<EntityType<C>> mobType, String englishName, String spanishName) {
        this.mobType = mobType;
        this.englishName = englishName;
        this.spanishName = spanishName;
        ALL_MOBS.add(this);
    }

    public C create(Level world) {
        return (C)((Mob)((EntityType)this.mobType.get()).m_20615_(world));
    }

    public RegisteredCreature<C> spawnEgg(int backgroundColor, int highlightColor) {
        String name = this.mobType.getKey().m_135782_().m_135815_() + "_spawn_egg";
        this.maybeSpawnEgg = Optional.of((RegisteredItem)((RegisteredItem)PMRegistries.regItem(name, () -> new ForgeSpawnEggItem(this.mobType, backgroundColor, highlightColor, new Item.Properties())).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_)).model((item, generator) -> ((ItemModelBuilder)generator.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:item/template_spawn_egg"))).localizedName(this.englishName + " Spawn Egg", "Generar " + this.spanishName.toLowerCase()));
        return this;
    }

    public RegisteredItem getSpawnEgg() {
        if (this.maybeSpawnEgg.isPresent()) {
            return this.maybeSpawnEgg.get();
        }
        return (RegisteredItem)Utils.modErrorTyped("A spawn egg doesn't exist for this mob!");
    }

    public void translations(PMTranslations translator, boolean isSpanish) {
        String name = this.mobType.getKey().m_135782_().m_135815_();
        String key = "entity.paradisemod." + name;
        translator.add(key, isSpanish ? this.spanishName : this.englishName);
    }

    @Override
    public EntityType<C> get() {
        return (EntityType)this.mobType.get();
    }
}

