/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.registry;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.data.assets.ItemModelGenerator;
import net.paradisemod.base.registry.RegisteredObject;

public class RegisteredItem
extends RegisteredObject<RegisteredItem>
implements Supplier<Item> {
    public static final ArrayListMultimap<TagKey<Item>, Supplier<? extends Item>> TAGGED_ITEMS = ArrayListMultimap.create();
    public static final ArrayList<RegisteredItem> ALL_ITEMS = new ArrayList();
    private final RegistryObject<Item> item;
    @Nullable
    private BiConsumer<RegisteredItem, ItemModelGenerator> model = null;

    protected RegisteredItem(RegistryObject<Item> item, boolean forBlock) {
        this.item = item;
        if (!forBlock) {
            ALL_ITEMS.add(this);
        }
    }

    @Override
    public Item get() {
        return (Item)this.item.get();
    }

    public RegisteredItem tag(TagKey<Item> tag) {
        TAGGED_ITEMS.put(tag, (Object)this);
        return this;
    }

    public RegisteredItem tags(TagKey<Item> ... tags) {
        for (TagKey<Item> tag : tags) {
            TAGGED_ITEMS.put(tag, (Object)this);
        }
        return this;
    }

    public RegisteredItem modelAlreadyExists() {
        this.model = (item, provider) -> {};
        return this;
    }

    public RegisteredItem model(BiConsumer<RegisteredItem, ItemModelGenerator> model) {
        this.model = model;
        return this;
    }

    public void genModel(ItemModelGenerator generator) {
        if (this.model != null) {
            this.model.accept(this, generator);
        } else {
            generator.basicItem(this.get());
        }
    }

    @Override
    public String registeredName() {
        return this.item.getKey().m_135782_().toString();
    }

    @Override
    public String shortName() {
        return this.item.getKey().m_135782_().m_135815_();
    }

    public Item m_5456_() {
        return this.get();
    }

    public ResourceKey<Item> getKey() {
        return this.item.getKey();
    }
}

