/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.base.registry;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.paradisemod.base.data.RecipeGenerator;
import net.paradisemod.base.mixin.datagen.SimpleCookingRecipeBuilderAccessor;
import net.paradisemod.base.registry.RegisteredCreativeTab;

public abstract class RegisteredObject<T extends RegisteredObject<T>>
implements ItemLike {
    private final ArrayList<BiFunction<Item, RecipeGenerator, ? extends RecipeBuilder>> recipes = new ArrayList();
    private final ArrayList<BiFunction<Item, RecipeGenerator, SmithingTransformRecipeBuilder>> smithingRecipes = new ArrayList();
    private final ArrayList<ResourceKey<CreativeModeTab>> creativeTabs = new ArrayList();
    private String englishName = "";
    private String spanishName = "";

    private T self() {
        return (T)this;
    }

    public abstract String shortName();

    public abstract String registeredName();

    public T recipe(BiFunction<Item, RecipeGenerator, ? extends RecipeBuilder> recipe) {
        this.recipes.add(recipe);
        return this.self();
    }

    public T smithingRecipe(BiFunction<Item, RecipeGenerator, SmithingTransformRecipeBuilder> recipe) {
        this.smithingRecipes.add(recipe);
        return this.self();
    }

    public T oreRecipes(ItemLike oreBlock) {
        return ((RegisteredObject)this.recipe((item, generator) -> generator.furnaceRecipe(oreBlock, (ItemLike)item, RecipeCategory.MISC))).recipe((item, generator) -> generator.blastingRecipe(oreBlock, (ItemLike)item, RecipeCategory.MISC));
    }

    public T cookedFoodRecipes(ItemLike rawFood) {
        return ((RegisteredObject)((RegisteredObject)this.recipe((item, generator) -> generator.campfireRecipe(rawFood, (ItemLike)item, RecipeCategory.MISC))).recipe((item, generator) -> generator.smokingRecipe(rawFood, (ItemLike)item, RecipeCategory.MISC))).recipe((item, generator) -> generator.furnaceRecipe(rawFood, (ItemLike)item, RecipeCategory.MISC));
    }

    public T stonecutterRecipes(int count, ItemLike ... inputs) {
        for (ItemLike input : inputs) {
            this.recipes.add((item, generator) -> generator.stonecutterRecipe(input, (ItemLike)this.m_5456_(), count));
        }
        return this.self();
    }

    public T stonecutterRecipes(ItemLike ... inputs) {
        return this.stonecutterRecipes(1, inputs);
    }

    public T tab(ResourceKey<CreativeModeTab> tab) {
        this.creativeTabs.add(tab);
        return this.self();
    }

    @SafeVarargs
    public final T tabs(ResourceKey<CreativeModeTab> ... tabs) {
        this.creativeTabs.addAll(List.of(tabs));
        return this.self();
    }

    public T tab(RegisteredCreativeTab tab) {
        return this.tab(tab.key());
    }

    public T localizedName(String englishName, String spanishName) {
        this.englishName = englishName;
        this.spanishName = spanishName;
        return this.self();
    }

    public String getLocalizedName(boolean isSpanish) {
        return isSpanish ? this.spanishName : this.englishName;
    }

    public boolean hasTab(ResourceKey<CreativeModeTab> key) {
        return this.creativeTabs.contains(key);
    }

    public boolean hasRecipes() {
        return !this.recipes.isEmpty() || !this.smithingRecipes.isEmpty();
    }

    public void genRecipes(RecipeGenerator generator, Consumer<FinishedRecipe> output) {
        ArrayListMultimap sortedRecipes = ArrayListMultimap.create();
        String name = this.shortName();
        for (BiFunction<Item, RecipeGenerator, ? extends RecipeBuilder> biFunction : this.recipes) {
            RecipeBuilder recipeBuilder = biFunction.apply(this.m_5456_(), generator);
            if (recipeBuilder instanceof SimpleCookingRecipeBuilder) {
                SimpleCookingRecipeBuilder furnaceRecipe = (SimpleCookingRecipeBuilder)recipeBuilder;
                RecipeSerializer<? extends AbstractCookingRecipe> serializer = ((SimpleCookingRecipeBuilderAccessor)furnaceRecipe).getSerializer();
                ResourceLocation key = ForgeRegistries.RECIPE_SERIALIZERS.getKey(serializer);
                sortedRecipes.put((Object)key.m_135815_(), (Object)furnaceRecipe);
                continue;
            }
            if (recipeBuilder instanceof SingleItemRecipeBuilder) {
                SingleItemRecipeBuilder stonecutterRecipe = (SingleItemRecipeBuilder)recipeBuilder;
                sortedRecipes.put((Object)"stonecutter", (Object)stonecutterRecipe);
                continue;
            }
            sortedRecipes.put((Object)"crafting", (Object)recipeBuilder);
        }
        for (Map.Entry entry : sortedRecipes.asMap().entrySet()) {
            int idx = 0;
            String recipeType = (String)entry.getKey();
            for (RecipeBuilder recipe : (Collection)entry.getValue()) {
                Object outputName = name;
                if (recipeType != "crafting") {
                    outputName = recipeType + "/" + (String)outputName;
                }
                if (idx > 0) {
                    outputName = (String)outputName + "_" + (idx + 1);
                }
                if (outputName == name) {
                    recipe.m_176498_(output);
                } else {
                    recipe.m_176500_(output, "paradisemod:" + (String)outputName);
                }
                ++idx;
            }
        }
        int idx = 0;
        for (BiFunction<Item, RecipeGenerator, SmithingTransformRecipeBuilder> recipe : this.smithingRecipes) {
            String outputName = "paradisemod:smithing/" + name;
            SmithingTransformRecipeBuilder builder = recipe.apply(this.m_5456_(), generator);
            if (idx > 0) {
                outputName = outputName + "_" + (idx + 1);
            }
            builder.m_266260_(output, outputName);
            ++idx;
        }
    }
}

