/*
 * Decompiled with CFR 0.152.
 */
package net.paradisemod.bonus;

import java.util.HashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.paradisemod.base.Utils;
import net.paradisemod.base.data.assets.PMTranslations;
import net.paradisemod.base.registry.PMRegistries;
import net.paradisemod.base.registry.RegisteredItem;

public class PMBannerPatterns {
    private static final DeferredRegister<BannerPattern> PATTERNS = PMRegistries.createRegistry(Registries.f_256969_);
    public static final HashMap<TagKey<BannerPattern>, RegistryObject<BannerPattern>> REGISTERED_BANNERS = new HashMap();
    public static final RegistryObject<BannerPattern> ZOMBIE_CHARGE = PMBannerPatterns.createPattern("zombie_charge", "zc");
    public static final RegistryObject<BannerPattern> DAVID_STAR = PMBannerPatterns.createPattern("david_star", "ds");
    public static final RegistryObject<BannerPattern> ICTUS = PMBannerPatterns.createPattern("ictus", "ict");
    public static final RegistryObject<BannerPattern> TRIQUETRA = PMBannerPatterns.createPattern("triquetra", "tri");
    public static final RegisteredItem ZOMBIE_CHARGE_PATTERN = (RegisteredItem)PMBannerPatterns.createPatternItem("zombie_charge").recipe((item, generator) -> generator.shapelessRecipe(RecipeCategory.MISC, (ItemLike)item, new ItemLike[]{Blocks.f_50314_, Items.f_42516_}));
    public static final RegisteredItem ICTUS_PATTERN = (RegisteredItem)PMBannerPatterns.createPatternItem("ictus").recipe((item, generator) -> generator.getShapedBuilder(RecipeCategory.MISC, (ItemLike)item).m_126130_(" g ").m_126130_("gpg").m_126130_(" g ").m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('p'), (ItemLike)Items.f_42516_));
    public static final RegisteredItem DAVID_STAR_PATTERN = PMBannerPatterns.createPatternItem("david_star");
    public static final RegisteredItem TRIQUETRA_PATTERN = PMBannerPatterns.createPatternItem("triquetra");

    public static void init(IEventBus eventBus) {
        PATTERNS.register(eventBus);
    }

    public static void translations(PMTranslations translator) {
        translator.addBanner(ZOMBIE_CHARGE, "Zombie Charge", "Cargo de Zombi");
        translator.addBanner(DAVID_STAR, "Star of David", "Estrella de David");
        translator.addBanner(ICTUS, "Ictus", "Ictus");
        translator.addBanner(TRIQUETRA, "Triquetra", "Triquetra");
    }

    private static RegistryObject<BannerPattern> createPattern(String name, String hash) {
        TagKey bannerKey = TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)new ResourceLocation("paradisemod", name));
        RegistryObject regPattern = Utils.handlePossibleException(() -> PATTERNS.register(name, () -> new BannerPattern(hash)));
        REGISTERED_BANNERS.put((TagKey<BannerPattern>)bannerKey, (RegistryObject<BannerPattern>)regPattern);
        return regPattern;
    }

    private static RegisteredItem createPatternItem(String name) {
        TagKey bannerKey = TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)new ResourceLocation("paradisemod", name));
        return (RegisteredItem)((RegisteredItem)PMRegistries.regItem(name + "_pattern", () -> new BannerPatternItem(bannerKey, new Item.Properties())).model((item, generator) -> generator.basicItem(item.get(), generator.mcLoc("item/skull_banner_pattern"))).localizedName("Banner Pattern", "Dise\u00f1o de estandarte")).tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256968_);
    }
}

